/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedLockTokenState {
    private ReplicatedLockTokenRequest currentToken = ReplicatedLockTokenRequest.INVALID_REPLICATED_LOCK_TOKEN_REQUEST;
    private long ordinal = -1L;

    public ReplicatedLockTokenState() {
    }

    public ReplicatedLockTokenState(long ordinal, ReplicatedLockTokenRequest currentToken) {
        this.ordinal = ordinal;
        this.currentToken = currentToken;
    }

    public void set(ReplicatedLockTokenRequest currentToken, long ordinal) {
        this.currentToken = currentToken;
        this.ordinal = ordinal;
    }

    public ReplicatedLockTokenRequest get() {
        return this.currentToken;
    }

    long ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return String.format("ReplicatedLockTokenState{currentToken=%s, ordinal=%d}", this.currentToken, this.ordinal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedLockTokenState that = (ReplicatedLockTokenState)o;
        return this.ordinal == that.ordinal && Objects.equals(this.currentToken, that.currentToken);
    }

    public int hashCode() {
        return Objects.hash(this.currentToken, this.ordinal);
    }

    ReplicatedLockTokenState newInstance() {
        return new ReplicatedLockTokenState(this.ordinal, this.currentToken);
    }

    public static class Marshal
    extends SafeStateMarshal<ReplicatedLockTokenState> {
        private final ChannelMarshal<MemberId> memberMarshal;

        public Marshal(ChannelMarshal<MemberId> memberMarshal) {
            this.memberMarshal = memberMarshal;
        }

        @Override
        public void marshal(ReplicatedLockTokenState state, WritableChannel channel) throws IOException {
            channel.putLong(state.ordinal);
            channel.putInt(state.get().id());
            this.memberMarshal.marshal(state.get().owner(), channel);
        }

        @Override
        public ReplicatedLockTokenState unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            long logIndex = channel.getLong();
            int candidateId = channel.getInt();
            MemberId member = this.memberMarshal.unmarshal(channel);
            return new ReplicatedLockTokenState(logIndex, new ReplicatedLockTokenRequest(member, candidateId));
        }

        @Override
        public ReplicatedLockTokenState startState() {
            return new ReplicatedLockTokenState();
        }

        @Override
        public long ordinal(ReplicatedLockTokenState state) {
            return state.ordinal();
        }
    }
}

