/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTransactionCommitProcess
implements TransactionCommitProcess {
    private final Replicator replicator;

    public ReplicatedTransactionCommitProcess(Replicator replicator) {
        this.replicator = replicator;
    }

    public long commit(TransactionToApply tx, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        Future<Object> futureTxId;
        ReplicatedTransaction transaction = ReplicatedTransactionFactory.createImmutableReplicatedTransaction(tx.transactionRepresentation());
        try {
            futureTxId = this.replicator.replicate(transaction, true);
        }
        catch (InterruptedException e) {
            throw new TransactionFailureException("Interrupted replicating transaction.", (Throwable)e);
        }
        try {
            return (Long)futureTxId.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TransactionFailureException) {
                throw (TransactionFailureException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new TransactionFailureException("Interrupted while waiting for txId", (Throwable)e);
        }
    }
}

