/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.storage;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.StateRecoveryManager;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.WritableChannel;

public class DurableStateStorage<STATE>
extends LifecycleAdapter
implements StateStorage<STATE> {
    private final StateRecoveryManager<STATE> recoveryManager;
    private final Log log;
    private STATE initialState;
    private final File fileA;
    private final File fileB;
    private final FileSystemAbstraction fsa;
    private final String name;
    private final StateMarshal<STATE> marshal;
    private final int numberOfEntriesBeforeRotation;
    private int numberOfEntriesWrittenInActiveFile;
    private File currentStoreFile;
    private PhysicalFlushableChannel currentStoreChannel;

    public DurableStateStorage(FileSystemAbstraction fsa, File baseDir, String name, StateMarshal<STATE> marshal, int numberOfEntriesBeforeRotation, LogProvider logProvider) {
        this.fsa = fsa;
        this.name = name;
        this.marshal = marshal;
        this.numberOfEntriesBeforeRotation = numberOfEntriesBeforeRotation;
        this.log = logProvider.getLog(this.getClass());
        this.recoveryManager = new StateRecoveryManager<STATE>(fsa, marshal);
        File parent = DurableStateStorage.stateDir(baseDir, name);
        this.fileA = new File(parent, name + ".a");
        this.fileB = new File(parent, name + ".b");
    }

    public boolean exists() {
        return this.fsa.fileExists(this.fileA) && this.fsa.fileExists(this.fileB);
    }

    private void create() throws IOException {
        this.ensureExists(this.fileA);
        this.ensureExists(this.fileB);
    }

    private void ensureExists(File file) throws IOException {
        if (!this.fsa.fileExists(file)) {
            this.fsa.mkdirs(file.getParentFile());
            try (PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fsa.create(file));){
                this.marshal.marshal(this.marshal.startState(), (WritableChannel)channel);
            }
        }
    }

    private void recover() throws IOException {
        StateRecoveryManager.RecoveryStatus<STATE> recoveryStatus = this.recoveryManager.recover(this.fileA, this.fileB);
        this.currentStoreFile = recoveryStatus.activeFile();
        this.currentStoreChannel = this.resetStoreFile(this.currentStoreFile);
        this.initialState = recoveryStatus.recoveredState();
        this.log.info("%s state restored, up to ordinal %d", new Object[]{this.name, this.marshal.ordinal(this.initialState)});
    }

    @Override
    public STATE getInitialState() {
        assert (this.initialState != null);
        return this.initialState;
    }

    public void init() throws IOException {
        this.create();
        this.recover();
    }

    public synchronized void shutdown() throws IOException {
        this.currentStoreChannel.close();
        this.currentStoreChannel = null;
    }

    @Override
    public synchronized void persistStoreData(STATE state) throws IOException {
        if (this.numberOfEntriesWrittenInActiveFile >= this.numberOfEntriesBeforeRotation) {
            this.switchStoreFile();
            this.numberOfEntriesWrittenInActiveFile = 0;
        }
        this.marshal.marshal(state, (WritableChannel)this.currentStoreChannel);
        this.currentStoreChannel.prepareForFlush().flush();
        ++this.numberOfEntriesWrittenInActiveFile;
    }

    void switchStoreFile() throws IOException {
        this.currentStoreChannel.close();
        if (this.currentStoreFile.equals(this.fileA)) {
            this.currentStoreChannel = this.resetStoreFile(this.fileB);
            this.currentStoreFile = this.fileB;
        } else {
            this.currentStoreChannel = this.resetStoreFile(this.fileA);
            this.currentStoreFile = this.fileA;
        }
    }

    private PhysicalFlushableChannel resetStoreFile(File nextStore) throws IOException {
        this.fsa.truncate(nextStore, 0L);
        return new PhysicalFlushableChannel(this.fsa.open(nextStore, OpenMode.READ_WRITE));
    }

    static File stateDir(File baseDir, String name) {
        return new File(baseDir, name + "-state");
    }
}

