/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.storage;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SimpleStorage;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class SimpleFileStorage<T>
implements SimpleStorage<T> {
    private final FileSystemAbstraction fileSystem;
    private final ChannelMarshal<T> marshal;
    private final File file;
    private Log log;

    public SimpleFileStorage(FileSystemAbstraction fileSystem, File directory, String name, ChannelMarshal<T> marshal, LogProvider logProvider) {
        this.fileSystem = fileSystem;
        this.log = logProvider.getLog(this.getClass());
        this.file = new File(DurableStateStorage.stateDir(directory, name), name);
        this.marshal = marshal;
    }

    @Override
    public boolean exists() {
        return this.fileSystem.fileExists(this.file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readState() throws IOException {
        try (ReadAheadChannel channel = new ReadAheadChannel(this.fileSystem.open(this.file, OpenMode.READ));){
            T t = this.marshal.unmarshal((ReadableChannel)channel);
            return t;
        }
        catch (EndOfStreamException e) {
            this.log.error("End of stream reached: " + this.file);
            throw new IOException(e);
        }
    }

    @Override
    public void writeState(T state) throws IOException {
        this.fileSystem.mkdirs(this.file.getParentFile());
        this.fileSystem.deleteFile(this.file);
        try (PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fileSystem.create(this.file));){
            this.marshal.marshal(state, (WritableChannel)channel);
        }
    }
}

