/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.identity.MemberId;

public class ReadReplicaTopology
implements Topology<ReadReplicaInfo> {
    static final ReadReplicaTopology EMPTY = new ReadReplicaTopology(Collections.emptyMap());
    private final Map<MemberId, ReadReplicaInfo> readReplicaMembers;

    public ReadReplicaTopology(Map<MemberId, ReadReplicaInfo> readReplicaMembers) {
        this.readReplicaMembers = readReplicaMembers;
    }

    public Collection<ReadReplicaInfo> allMemberInfo() {
        return this.readReplicaMembers.values();
    }

    @Override
    public Map<MemberId, ReadReplicaInfo> members() {
        return this.readReplicaMembers;
    }

    public String toString() {
        return String.format("{readReplicas=%s}", this.readReplicaMembers);
    }

    public Optional<MemberId> randomReadReplicaMemberId() {
        if (this.readReplicaMembers.isEmpty()) {
            return Optional.empty();
        }
        return this.readReplicaMembers.keySet().stream().skip(ThreadLocalRandom.current().nextInt(this.readReplicaMembers.size())).findFirst();
    }

    public ReadReplicaTopology filterTopologyByDb(String dbName) {
        Map<MemberId, ReadReplicaInfo> filteredMembers = this.filterHostsByDb(this.members(), dbName);
        return new ReadReplicaTopology(filteredMembers);
    }
}

