/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.core.HazelcastInstance;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.discovery.HazelcastInstanceNotActiveException;

class RobustHazelcastWrapper {
    private final HazelcastConnector connector;
    private HazelcastInstance hzInstance;
    private boolean shutdown;

    RobustHazelcastWrapper(HazelcastConnector connector) {
        this.connector = connector;
    }

    synchronized void shutdown() {
        if (this.hzInstance != null) {
            this.hzInstance.shutdown();
            this.hzInstance = null;
            this.shutdown = true;
        }
    }

    private synchronized HazelcastInstance tryEnsureConnection() throws HazelcastInstanceNotActiveException {
        if (this.shutdown) {
            throw new HazelcastInstanceNotActiveException("Shutdown");
        }
        if (this.hzInstance == null) {
            this.hzInstance = this.connector.connectToHazelcast();
        }
        return this.hzInstance;
    }

    private synchronized void invalidateConnection() {
        this.hzInstance = null;
    }

    synchronized <T> T apply(Function<HazelcastInstance, T> function) throws HazelcastInstanceNotActiveException {
        HazelcastInstance hzInstance = this.tryEnsureConnection();
        try {
            return function.apply(hzInstance);
        }
        catch (com.hazelcast.core.HazelcastInstanceNotActiveException e) {
            this.invalidateConnection();
            throw new HazelcastInstanceNotActiveException(e);
        }
    }

    synchronized void perform(Consumer<HazelcastInstance> operation) throws HazelcastInstanceNotActiveException {
        HazelcastInstance hzInstance = this.tryEnsureConnection();
        try {
            operation.accept(hzInstance);
        }
        catch (com.hazelcast.core.HazelcastInstanceNotActiveException e) {
            this.invalidateConnection();
            throw new HazelcastInstanceNotActiveException(e);
        }
    }
}

