/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class SrvHostnameResolver
implements HostnameResolver {
    private final Log userLog;
    private final Log log;
    private final SrvRecordResolver srvRecordResolver;

    public SrvHostnameResolver(LogProvider logProvider, LogProvider userLogProvider, SrvRecordResolver srvRecordResolver) {
        this.log = logProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.srvRecordResolver = srvRecordResolver;
    }

    @Override
    public Collection<AdvertisedSocketAddress> resolve(AdvertisedSocketAddress initialAddress) {
        try {
            Set<AdvertisedSocketAddress> addresses = this.srvRecordResolver.resolveSrvRecord(initialAddress.getHostname()).map(srvRecord -> new AdvertisedSocketAddress(srvRecord.host, srvRecord.port)).collect(Collectors.toSet());
            this.userLog.info("Resolved initial host '%s' to %s", new Object[]{initialAddress, addresses});
            if (addresses.isEmpty()) {
                this.log.error("Failed to resolve srv records for '%s'", new Object[]{initialAddress.getHostname()});
            }
            return addresses;
        }
        catch (NamingException e) {
            this.log.error("Failed to resolve srv records for '%s'", new Object[]{initialAddress.getHostname(), e});
            return Collections.emptySet();
        }
    }
}

