/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public abstract class SuspendableLifeCycle
implements Lifecycle,
Suspendable {
    private final Log debugLog;
    private boolean stoppedByLifeCycle = true;
    private boolean enabled = true;

    public SuspendableLifeCycle(Log debugLog) {
        this.debugLog = debugLog;
    }

    @Override
    public final synchronized void enable() throws Throwable {
        if (!this.stoppedByLifeCycle) {
            this.start0();
        } else {
            this.debugLog.info("%s will not start. It was enabled but is stopped by lifecycle", new Object[]{this});
        }
        this.enabled = true;
    }

    @Override
    public final synchronized void disable() throws Throwable {
        this.stop0();
        this.enabled = false;
    }

    public final synchronized void init() throws Throwable {
        this.init0();
    }

    public final synchronized void start() throws Throwable {
        if (!this.enabled) {
            this.debugLog.info("Start call from lifecycle is ignored because %s is disabled.", new Object[]{this});
        } else {
            this.start0();
        }
        this.stoppedByLifeCycle = false;
    }

    public final synchronized void stop() throws Throwable {
        this.stop0();
        this.stoppedByLifeCycle = true;
    }

    public final synchronized void shutdown() throws Throwable {
        this.shutdown0();
        this.stoppedByLifeCycle = true;
    }

    protected abstract void init0() throws Throwable;

    protected abstract void start0() throws Throwable;

    protected abstract void stop0() throws Throwable;

    protected abstract void shutdown0() throws Throwable;
}

