/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class MemberId
implements Serializable {
    private final UUID uuid;
    private final String shortName;

    public MemberId(UUID uuid) {
        Objects.requireNonNull(uuid);
        this.uuid = uuid;
        this.shortName = uuid.toString().substring(0, 8);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String toString() {
        return String.format("MemberId{%s}", this.shortName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberId that = (MemberId)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public static class Marshal
    extends SafeStateMarshal<MemberId> {
        private static final Charset UTF8 = Charset.forName("UTF-8");

        @Override
        public void marshal(MemberId memberId, WritableChannel channel) throws IOException {
            if (memberId == null) {
                channel.put((byte)0);
            } else {
                channel.put((byte)1);
                channel.putLong(memberId.uuid.getMostSignificantBits());
                channel.putLong(memberId.uuid.getLeastSignificantBits());
            }
        }

        @Override
        public MemberId unmarshal0(ReadableChannel channel) throws IOException {
            byte nullMarker = channel.get();
            if (nullMarker == 0) {
                return null;
            }
            long mostSigBits = channel.getLong();
            long leastSigBits = channel.getLong();
            return new MemberId(new UUID(mostSigBits, leastSigBits));
        }

        @Override
        public MemberId startState() {
            return null;
        }

        @Override
        public long ordinal(MemberId memberId) {
            return memberId == null ? 0L : 1L;
        }
    }
}

