/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.util.Objects;

public final class StoreId {
    public static final StoreId DEFAULT = new StoreId(org.neo4j.kernel.impl.store.StoreId.DEFAULT.getCreationTime(), org.neo4j.kernel.impl.store.StoreId.DEFAULT.getRandomId(), org.neo4j.kernel.impl.store.StoreId.DEFAULT.getUpgradeTime(), org.neo4j.kernel.impl.store.StoreId.DEFAULT.getUpgradeId());
    private long creationTime;
    private long randomId;
    private long upgradeTime;
    private long upgradeId;

    public static boolean isDefault(StoreId storeId) {
        return storeId.getCreationTime() == DEFAULT.getCreationTime() && storeId.getRandomId() == DEFAULT.getRandomId() && storeId.getUpgradeTime() == DEFAULT.getUpgradeTime() && storeId.getUpgradeId() == DEFAULT.getUpgradeId();
    }

    public StoreId(long creationTime, long randomId, long upgradeTime, long upgradeId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.upgradeTime = upgradeTime;
        this.upgradeId = upgradeId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getUpgradeTime() {
        return this.upgradeTime;
    }

    public long getUpgradeId() {
        return this.upgradeId;
    }

    public boolean equalToKernelStoreId(org.neo4j.kernel.impl.store.StoreId kenelStoreId) {
        return this.creationTime == kenelStoreId.getCreationTime() && this.randomId == kenelStoreId.getRandomId() && this.upgradeTime == kenelStoreId.getUpgradeTime() && this.upgradeId == kenelStoreId.getUpgradeId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (StoreId.isDefault(this)) {
            return false;
        }
        StoreId storeId = (StoreId)o;
        if (StoreId.isDefault(storeId)) {
            return false;
        }
        return this.creationTime == storeId.creationTime && this.randomId == storeId.randomId && this.upgradeTime == storeId.upgradeTime && this.upgradeId == storeId.upgradeId;
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.randomId, this.upgradeTime, this.upgradeId);
    }

    public String toString() {
        return String.format("Store{creationTime:%d, randomId:%s, upgradeTime:%d, upgradeId:%d}", this.creationTime, this.randomId, this.upgradeTime, this.upgradeId);
    }
}

