/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.logging;

import java.io.PrintWriter;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class BetterMessageLogger<MEMBER>
extends LifecycleAdapter
implements MessageLogger<MEMBER> {
    private final PrintWriter printWriter;
    private final Clock clock;
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ");

    public BetterMessageLogger(MEMBER myself, PrintWriter printWriter, Clock clock) {
        this.printWriter = printWriter;
        this.clock = clock;
        this.log(myself, Direction.INFO, myself, "Info", "I am " + myself);
    }

    private void log(MEMBER me, Direction direction, MEMBER remote, String type, String message) {
        this.printWriter.println(String.format("%s %s %s %s %s \"%s\"", ZonedDateTime.now(this.clock).format(this.dateTimeFormatter), me, direction.arrow, remote, type, message));
        this.printWriter.flush();
    }

    @Override
    public <M extends RaftMessages.RaftMessage> void logOutbound(MEMBER me, M message, MEMBER remote) {
        this.log(me, Direction.OUTBOUND, remote, this.nullSafeMessageType(message), String.valueOf(message));
    }

    @Override
    public <M extends RaftMessages.RaftMessage> void logInbound(MEMBER remote, M message, MEMBER me) {
        this.log(me, Direction.INBOUND, remote, this.nullSafeMessageType(message), String.valueOf(message));
    }

    private <M extends RaftMessages.RaftMessage> String nullSafeMessageType(M message) {
        if (Objects.isNull(message)) {
            return "null";
        }
        return message.type().toString();
    }

    public void stop() {
        this.printWriter.close();
    }

    private static enum Direction {
        INFO("---"),
        OUTBOUND("-->"),
        INBOUND("<--");

        public final String arrow;

        private Direction(String arrow) {
            this.arrow = arrow;
        }
    }
}

