/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSetSerializer;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenSerializer;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionSerializer;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreReplicatedContentMarshal
extends SafeChannelMarshal<ReplicatedContent> {
    private static final byte TX_CONTENT_TYPE = 0;
    private static final byte RAFT_MEMBER_SET_TYPE = 1;
    private static final byte ID_RANGE_REQUEST_TYPE = 2;
    private static final byte TOKEN_REQUEST_TYPE = 4;
    private static final byte NEW_LEADER_BARRIER_TYPE = 5;
    private static final byte LOCK_TOKEN_REQUEST = 6;
    private static final byte DISTRIBUTED_OPERATION = 7;
    private static final byte DUMMY_REQUEST = 8;

    @Override
    public void marshal(ReplicatedContent content, WritableChannel channel) throws IOException {
        if (content instanceof ReplicatedTransaction) {
            channel.put((byte)0);
            ReplicatedTransactionSerializer.marshal((ReplicatedTransaction)content, channel);
        } else if (content instanceof MemberIdSet) {
            channel.put((byte)1);
            MemberIdSetSerializer.marshal((MemberIdSet)content, channel);
        } else if (content instanceof ReplicatedIdAllocationRequest) {
            channel.put((byte)2);
            ReplicatedIdAllocationRequestSerializer.marshal((ReplicatedIdAllocationRequest)content, channel);
        } else if (content instanceof ReplicatedTokenRequest) {
            channel.put((byte)4);
            ReplicatedTokenRequestSerializer.marshal((ReplicatedTokenRequest)content, channel);
        } else if (content instanceof NewLeaderBarrier) {
            channel.put((byte)5);
        } else if (content instanceof ReplicatedLockTokenRequest) {
            channel.put((byte)6);
            ReplicatedLockTokenSerializer.marshal((ReplicatedLockTokenRequest)content, channel);
        } else if (content instanceof DistributedOperation) {
            channel.put((byte)7);
            ((DistributedOperation)content).serialize(channel);
        } else if (content instanceof DummyRequest) {
            channel.put((byte)8);
            DummyRequest.Marshal.INSTANCE.marshal((DummyRequest)content, channel);
        } else {
            throw new IllegalArgumentException("Unknown content type " + content.getClass());
        }
    }

    @Override
    public ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
        ReplicatedContent content;
        byte type = channel.get();
        switch (type) {
            case 0: {
                content = ReplicatedTransactionSerializer.unmarshal(channel);
                break;
            }
            case 1: {
                content = MemberIdSetSerializer.unmarshal(channel);
                break;
            }
            case 2: {
                content = ReplicatedIdAllocationRequestSerializer.unmarshal(channel);
                break;
            }
            case 4: {
                content = ReplicatedTokenRequestSerializer.unmarshal(channel);
                break;
            }
            case 5: {
                content = new NewLeaderBarrier();
                break;
            }
            case 6: {
                content = ReplicatedLockTokenSerializer.unmarshal(channel);
                break;
            }
            case 7: {
                content = DistributedOperation.deserialize(channel);
                break;
            }
            case 8: {
                content = (ReplicatedContent)DummyRequest.Marshal.INSTANCE.unmarshal(channel);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown content type 0x%x", type));
            }
        }
        return content;
    }
}

