/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import java.io.Flushable;
import org.neo4j.causalclustering.messaging.MessageTooBigException;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class NetworkFlushableChannelNetty4
implements FlushableChannel {
    private static final long DEFAULT_SIZE_LIMIT = ByteUnit.mebiBytes((long)2L);
    private final ByteBuf delegate;
    private final int initialWriterIndex;
    private final long sizeLimit;

    public NetworkFlushableChannelNetty4(ByteBuf delegate) {
        this(delegate, DEFAULT_SIZE_LIMIT);
    }

    public NetworkFlushableChannelNetty4(ByteBuf delegate, long sizeLimit) {
        this.delegate = delegate;
        this.initialWriterIndex = delegate.writerIndex();
        this.sizeLimit = sizeLimit;
    }

    public Flushable prepareForFlush() {
        return null;
    }

    public FlushableChannel put(byte value) throws MessageTooBigException {
        this.checkSize(1);
        this.delegate.writeByte((int)value);
        return this;
    }

    public FlushableChannel putShort(short value) throws MessageTooBigException {
        this.checkSize(2);
        this.delegate.writeShort((int)value);
        return this;
    }

    public FlushableChannel putInt(int value) throws MessageTooBigException {
        this.checkSize(4);
        this.delegate.writeInt(value);
        return this;
    }

    public FlushableChannel putLong(long value) throws MessageTooBigException {
        this.checkSize(8);
        this.delegate.writeLong(value);
        return this;
    }

    public FlushableChannel putFloat(float value) throws MessageTooBigException {
        this.checkSize(4);
        this.delegate.writeFloat(value);
        return this;
    }

    public FlushableChannel putDouble(double value) throws MessageTooBigException {
        this.checkSize(8);
        this.delegate.writeDouble(value);
        return this;
    }

    public FlushableChannel put(byte[] value, int length) throws MessageTooBigException {
        this.checkSize(length);
        this.delegate.writeBytes(value, 0, length);
        return this;
    }

    public void close() {
    }

    private void checkSize(int additional) throws MessageTooBigException {
        int writtenSoFar = this.delegate.writerIndex() - this.initialWriterIndex;
        int countToCheck = writtenSoFar + additional;
        if ((long)countToCheck > this.sizeLimit) {
            throw new MessageTooBigException(String.format("Size limit exceeded. Limit is %d, wanted to write %d with the writer index at %d (started at %d), written so far %d", this.sizeLimit, additional, this.delegate.writerIndex(), this.initialWriterIndex, writtenSoFar));
        }
    }
}

