/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import java.util.concurrent.Future;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.logging.Log;

public class SimpleNettyChannel
implements Channel {
    private final Log log;
    private final io.netty.channel.Channel channel;
    private volatile boolean disposed;

    public SimpleNettyChannel(io.netty.channel.Channel channel, Log log) {
        this.channel = channel;
        this.log = log;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public synchronized void dispose() {
        this.log.info("Disposing channel: " + this.channel);
        this.disposed = true;
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public Future<Void> write(Object msg) {
        this.checkDisposed();
        return this.channel.write(msg);
    }

    @Override
    public Future<Void> writeAndFlush(Object msg) {
        this.checkDisposed();
        return this.channel.writeAndFlush(msg);
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("sending on disposed channel");
        }
    }
}

