/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.storeid;

import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public final class StoreIdMarshal
extends SafeChannelMarshal<StoreId> {
    public static final StoreIdMarshal INSTANCE = new StoreIdMarshal();

    private StoreIdMarshal() {
    }

    @Override
    public void marshal(StoreId storeId, WritableChannel channel) throws IOException {
        if (storeId == null) {
            channel.put((byte)0);
            return;
        }
        channel.put((byte)1);
        channel.putLong(storeId.getCreationTime());
        channel.putLong(storeId.getRandomId());
        channel.putLong(storeId.getUpgradeTime());
        channel.putLong(storeId.getUpgradeId());
    }

    @Override
    protected StoreId unmarshal0(ReadableChannel channel) throws IOException {
        byte exists = channel.get();
        if (exists == 0) {
            return null;
        }
        if (exists != 1) {
            throw new DecoderException("Unexpected value: " + exists);
        }
        long creationTime = channel.getLong();
        long randomId = channel.getLong();
        long upgradeTime = channel.getLong();
        long upgradeId = channel.getLong();
        return new StoreId(creationTime, randomId, upgradeTime, upgradeId);
    }
}

