/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.causalclustering.protocol.ClientNettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilder;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ServerNettyPipelineBuilder;
import org.neo4j.logging.Log;

public class NettyPipelineBuilderFactory {
    private final PipelineWrapper wrapper;

    public NettyPipelineBuilderFactory(PipelineWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public ClientNettyPipelineBuilder client(Channel channel, Log log) throws Exception {
        return this.create(channel, NettyPipelineBuilder.client(channel.pipeline(), log));
    }

    public ServerNettyPipelineBuilder server(Channel channel, Log log) throws Exception {
        return this.create(channel, NettyPipelineBuilder.server(channel.pipeline(), log));
    }

    private <O extends ProtocolInstaller.Orientation, BUILDER extends NettyPipelineBuilder<O, BUILDER>> BUILDER create(Channel channel, BUILDER nettyPipelineBuilder) throws Exception {
        int i = 0;
        for (ChannelHandler handler : this.wrapper.handlersFor(channel)) {
            nettyPipelineBuilder.add(String.format("%s_%d", this.wrapper.name(), i), handler);
            ++i;
        }
        return nettyPipelineBuilder;
    }
}

