/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.Protocol;

public interface ProtocolInstaller<O extends Orientation> {
    public void install(Channel var1) throws Exception;

    public Protocol.ApplicationProtocol applicationProtocol();

    public Collection<Collection<Protocol.ModifierProtocol>> modifiers();

    public static interface Orientation {

        public static interface Client
        extends Orientation {
            public static final String OUTBOUND = "outbound";
        }

        public static interface Server
        extends Orientation {
            public static final String INBOUND = "inbound";
        }
    }

    public static abstract class Factory<O extends Orientation, I extends ProtocolInstaller<O>> {
        private final Protocol.ApplicationProtocol applicationProtocol;
        private final Function<List<ModifierProtocolInstaller<O>>, I> constructor;

        protected Factory(Protocol.ApplicationProtocol applicationProtocol, Function<List<ModifierProtocolInstaller<O>>, I> constructor) {
            this.applicationProtocol = applicationProtocol;
            this.constructor = constructor;
        }

        I create(List<ModifierProtocolInstaller<O>> modifiers) {
            return (I)((ProtocolInstaller)this.constructor.apply(modifiers));
        }

        public Protocol.ApplicationProtocol applicationProtocol() {
            return this.applicationProtocol;
        }
    }
}

