/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.BaseProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;

public class ClientMessageDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws ClientHandshakeException {
        int messageCode = in.readInt();
        switch (messageCode) {
            case 877610318: {
                String magic = StringMarshal.unmarshal(in);
                out.add(new InitialMagicMessage(magic));
                return;
            }
            case 0: {
                ApplicationProtocolResponse applicationProtocolResponse = this.decodeProtocolResponse(ApplicationProtocolResponse::new, ByteBuf::readInt, in);
                out.add(applicationProtocolResponse);
                return;
            }
            case 1: {
                ModifierProtocolResponse modifierProtocolResponse = this.decodeProtocolResponse(ModifierProtocolResponse::new, StringMarshal::unmarshal, in);
                out.add(modifierProtocolResponse);
                return;
            }
            case 2: {
                int statusCodeValue = in.readInt();
                Optional<StatusCode> statusCode = StatusCode.fromCodeValue(statusCodeValue);
                if (statusCode.isPresent()) {
                    out.add(new SwitchOverResponse(statusCode.get()));
                }
                return;
            }
        }
    }

    private <U extends Comparable<U>, T extends BaseProtocolResponse<U>> T decodeProtocolResponse(TriFunction<StatusCode, String, U, T> constructor, Function<ByteBuf, U> reader, ByteBuf in) throws ClientHandshakeException {
        int statusCodeValue = in.readInt();
        String identifier = StringMarshal.unmarshal(in);
        Comparable version = (Comparable)reader.apply(in);
        Optional<StatusCode> statusCode = StatusCode.fromCodeValue(statusCodeValue);
        return (T)statusCode.map(status -> (BaseProtocolResponse)constructor.apply((StatusCode)((Object)status), identifier, (Object)version)).orElseThrow(() -> new ClientHandshakeException(String.format("Unknown status code %s for protocol %s version %d", statusCodeValue, identifier, version)));
    }

    @FunctionalInterface
    static interface TriFunction<T, U, V, W> {
        public W apply(T var1, U var2, V var3);
    }
}

