/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.List;
import java.util.Objects;
import org.neo4j.causalclustering.protocol.handshake.ServerMessage;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageHandler;
import org.neo4j.helpers.collection.Pair;

public class SwitchOverRequest
implements ServerMessage {
    private final String protocolName;
    private final Integer version;
    private final List<Pair<String, String>> modifierProtocols;

    public SwitchOverRequest(String applicationProtocolName, int applicationProtocolVersion, List<Pair<String, String>> modifierProtocols) {
        this.protocolName = applicationProtocolName;
        this.version = applicationProtocolVersion;
        this.modifierProtocols = modifierProtocols;
    }

    @Override
    public void dispatch(ServerMessageHandler handler) {
        handler.handle(this);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public List<Pair<String, String>> modifierProtocols() {
        return this.modifierProtocols;
    }

    public int version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchOverRequest that = (SwitchOverRequest)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.protocolName, that.protocolName) && Objects.equals(this.modifierProtocols, that.modifierProtocols);
    }

    public int hashCode() {
        return Objects.hash(this.protocolName, this.version, this.modifierProtocols);
    }

    public String toString() {
        return "SwitchOverRequest{protocolName='" + this.protocolName + '\'' + ", version=" + this.version + ", modifierProtocols=" + this.modifierProtocols + '}';
    }
}

