/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupProtocolClientInstaller;
import org.neo4j.causalclustering.catchup.CatchupServerBuilder;
import org.neo4j.causalclustering.catchup.CheckpointerSupplier;
import org.neo4j.causalclustering.catchup.RegularCatchupServerHandler;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.catchup.tx.BatchingTxApplier;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.SupportedProtocolCreator;
import org.neo4j.causalclustering.core.TransactionBackupServiceProvider;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.ResolutionResolverFactory;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.TopologyServiceMultiRetryStrategy;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.discovery.procedures.ReadReplicaRoleProcedure;
import org.neo4j.causalclustering.handlers.DuplexPipelineWrapperFactory;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.helper.CompositeSuspendable;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.net.InstalledProtocolHandler;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClientInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.readreplica.ReadReplicaLockManager;
import org.neo4j.causalclustering.readreplica.ReadReplicaStartupProcess;
import org.neo4j.causalclustering.readreplica.WaitForUpToDateStore;
import org.neo4j.causalclustering.upstream.NoOpUpstreamDatabaseStrategiesLoader;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategiesLoader;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.causalclustering.upstream.strategies.ConnectToRandomCoreServerStrategy;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.core.DelegatingLabelTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingPropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingRelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.enterprise.StandardBoltConnectionTracker;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.ReadOnly;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.stats.IdBasedStoreEntityCounters;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.DefaultKernelData;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.time.Clocks;
import org.neo4j.udc.UsageData;

public class EnterpriseReadReplicaEditionModule
extends EditionModule {
    public EnterpriseReadReplicaEditionModule(PlatformModule platformModule, DiscoveryServiceFactory discoveryServiceFactory, MemberId myself) {
        LogService logging = platformModule.logging;
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
        platformModule.jobScheduler.setTopLevelGroupName("ReadReplica " + myself);
        Dependencies dependencies = platformModule.dependencies;
        Config config = platformModule.config;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        PageCache pageCache = platformModule.pageCache;
        File storeDir = platformModule.storeDir;
        LifeSupport life = platformModule.life;
        this.eligibleForIdReuse = IdReuseEligibility.ALWAYS;
        this.accessCapability = new ReadOnly();
        this.watcherService = this.createFileSystemWatcherService(fileSystem, storeDir, logging, platformModule.jobScheduler, EnterpriseReadReplicaEditionModule.fileWatcherFileNameFilter());
        dependencies.satisfyDependencies(new Object[]{this.watcherService});
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        this.lockManager = (Locks)dependencies.satisfyDependency((Object)new ReadReplicaLockManager());
        this.statementLocksFactory = new StatementLocksFactorySelector(this.lockManager, config, logging).select();
        this.idTypeConfigurationProvider = new EnterpriseIdTypeConfigurationProvider(config);
        this.idGeneratorFactory = (IdGeneratorFactory)dependencies.satisfyDependency((Object)new DefaultIdGeneratorFactory(fileSystem, this.idTypeConfigurationProvider));
        this.idController = this.createDefaultIdController();
        dependencies.satisfyDependency((Object)this.idGeneratorFactory);
        dependencies.satisfyDependency((Object)this.idController);
        dependencies.satisfyDependency((Object)new IdBasedStoreEntityCounters(this.idGeneratorFactory));
        this.propertyKeyTokenHolder = (PropertyKeyTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency((Object)new DelegatingPropertyKeyTokenHolder((TokenCreator)new ReadOnlyTokenCreator())));
        this.labelTokenHolder = (LabelTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency((Object)new DelegatingLabelTokenHolder((TokenCreator)new ReadOnlyTokenCreator())));
        this.relationshipTypeTokenHolder = (RelationshipTypeTokenHolder)life.add((Lifecycle)dependencies.satisfyDependency((Object)new DelegatingRelationshipTypeTokenHolder((TokenCreator)new ReadOnlyTokenCreator())));
        life.add((Lifecycle)dependencies.satisfyDependency((Object)new DefaultKernelData(fileSystem, pageCache, storeDir, config, (GraphDatabaseAPI)graphDatabaseFacade)));
        this.headerInformationFactory = TransactionHeaderInformationFactory.DEFAULT;
        this.schemaWriteGuard = () -> {};
        this.transactionStartTimeout = ((Duration)config.get(GraphDatabaseSettings.transaction_start_timeout)).toMillis();
        this.constraintSemantics = new EnterpriseConstraintSemantics();
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(platformModule.availabilityGuard, this.transactionStartTimeout);
        this.registerRecovery(platformModule.databaseInfo, life, (DependencyResolver)dependencies);
        this.publishEditionInfo((UsageData)dependencies.resolveDependency(UsageData.class), platformModule.databaseInfo, config);
        this.commitProcessFactory = this.readOnly();
        LogProvider logProvider = platformModule.logging.getInternalLogProvider();
        LogProvider userLogProvider = platformModule.logging.getUserLogProvider();
        logProvider.getLog(((Object)((Object)this)).getClass()).info(String.format("Generated new id: %s", myself));
        HostnameResolver hostnameResolver = ResolutionResolverFactory.chooseResolver(config, logProvider, userLogProvider);
        this.configureDiscoveryService(discoveryServiceFactory, dependencies, config, logProvider);
        TopologyService topologyService = discoveryServiceFactory.topologyService(config, logProvider, platformModule.jobScheduler, myself, hostnameResolver, EnterpriseReadReplicaEditionModule.resolveStrategy(config, logProvider));
        life.add((Lifecycle)dependencies.satisfyDependency((Object)topologyService));
        dependencies.satisfyDependency((Object)SslPolicyLoader.create((Config)config, (LogProvider)logProvider));
        DuplexPipelineWrapperFactory pipelineWrapperFactory = this.pipelineWrapperFactory();
        PipelineWrapper serverPipelineWrapper = pipelineWrapperFactory.forServer(config, dependencies, logProvider, CausalClusteringSettings.ssl_policy);
        PipelineWrapper clientPipelineWrapper = pipelineWrapperFactory.forClient(config, dependencies, logProvider, CausalClusteringSettings.ssl_policy);
        PipelineWrapper backupServerPipelineWrapper = pipelineWrapperFactory.forServer(config, dependencies, logProvider, (Setting<String>)OnlineBackupSettings.ssl_policy);
        NettyPipelineBuilderFactory clientPipelineBuilderFactory = new NettyPipelineBuilderFactory(clientPipelineWrapper);
        NettyPipelineBuilderFactory serverPipelineBuilderFactory = new NettyPipelineBuilderFactory(serverPipelineWrapper);
        NettyPipelineBuilderFactory backupServerPipelineBuilderFactory = new NettyPipelineBuilderFactory(backupServerPipelineWrapper);
        SupportedProtocolCreator supportedProtocolCreator = new SupportedProtocolCreator(config, logProvider);
        ApplicationSupportedProtocols supportedCatchupProtocols = supportedProtocolCreator.createSupportedCatchupProtocol();
        List<ModifierSupportedProtocols> supportedModifierProtocols = supportedProtocolCreator.createSupportedModifierProtocols();
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), supportedCatchupProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), supportedModifierProtocols);
        Function<CatchUpResponseHandler, ChannelInitializer<SocketChannel>> channelInitializer = handler -> {
            ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client>(Collections.singletonList(new CatchupProtocolClientInstaller.Factory(clientPipelineBuilderFactory, logProvider, (CatchUpResponseHandler)handler)), ModifierProtocolInstaller.allClientInstallers);
            Duration handshakeTimeout = (Duration)config.get(CausalClusteringSettings.handshake_timeout);
            return new HandshakeClientInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, clientPipelineBuilderFactory, handshakeTimeout, logProvider);
        };
        long inactivityTimeoutMillis = ((Duration)config.get(CausalClusteringSettings.catch_up_client_inactivity_timeout)).toMillis();
        CatchUpClient catchUpClient = (CatchUpClient)life.add((Lifecycle)new CatchUpClient(logProvider, Clocks.systemClock(), inactivityTimeoutMillis, channelInitializer));
        Supplier databaseHealthSupplier = dependencies.provideDependency(DatabaseHealth.class);
        Supplier<TransactionCommitProcess> writableCommitProcess = () -> new TransactionRepresentationCommitProcess((TransactionAppender)dependencies.resolveDependency(TransactionAppender.class), (StorageEngine)dependencies.resolveDependency(StorageEngine.class));
        LifeSupport txPulling = new LifeSupport();
        int maxBatchSize = (Integer)config.get(CausalClusteringSettings.read_replica_transaction_applier_batch_size);
        BatchingTxApplier batchingTxApplier = new BatchingTxApplier(maxBatchSize, dependencies.provideDependency(TransactionIdStore.class), writableCommitProcess, platformModule.monitors, platformModule.tracers.pageCursorTracerSupplier, platformModule.versionContextSupplier, logProvider);
        TimerService timerService = new TimerService(platformModule.jobScheduler, logProvider);
        StoreFiles storeFiles = new StoreFiles(fileSystem, pageCache);
        LogFiles logFiles = this.buildLocalDatabaseLogFiles(platformModule, fileSystem, storeDir, config);
        LocalDatabase localDatabase = new LocalDatabase(platformModule.storeDir, storeFiles, logFiles, platformModule.dataSourceManager, databaseHealthSupplier, this.watcherService, platformModule.availabilityGuard, logProvider);
        ExponentialBackoffStrategy storeCopyBackoffStrategy = new ExponentialBackoffStrategy(1L, ((Duration)config.get(CausalClusteringSettings.store_copy_backoff_max_wait)).toMillis(), TimeUnit.MILLISECONDS);
        RemoteStore remoteStore = new RemoteStore(platformModule.logging.getInternalLogProvider(), fileSystem, platformModule.pageCache, new StoreCopyClient(catchUpClient, platformModule.monitors, logProvider, storeCopyBackoffStrategy), new TxPullClient(catchUpClient, platformModule.monitors), new TransactionLogCatchUpFactory(), config, platformModule.monitors);
        CopiedStoreRecovery copiedStoreRecovery = new CopiedStoreRecovery(config, platformModule.kernelExtensions.listFactories(), platformModule.pageCache);
        txPulling.add((Lifecycle)copiedStoreRecovery);
        CompositeSuspendable servicesToStopOnStoreCopy = new CompositeSuspendable();
        StoreCopyProcess storeCopyProcess = new StoreCopyProcess(fileSystem, pageCache, localDatabase, copiedStoreRecovery, remoteStore, logProvider);
        ConnectToRandomCoreServerStrategy defaultStrategy = new ConnectToRandomCoreServerStrategy();
        defaultStrategy.inject(topologyService, config, logProvider, myself);
        UpstreamDatabaseStrategySelector upstreamDatabaseStrategySelector = this.createUpstreamDatabaseStrategySelector(myself, config, logProvider, topologyService, defaultStrategy);
        CatchupPollingProcess catchupProcess = new CatchupPollingProcess(logProvider, localDatabase, servicesToStopOnStoreCopy, catchUpClient, upstreamDatabaseStrategySelector, timerService, ((Duration)config.get(CausalClusteringSettings.pull_interval)).toMillis(), batchingTxApplier, platformModule.monitors, storeCopyProcess, databaseHealthSupplier, topologyService);
        dependencies.satisfyDependencies(new Object[]{catchupProcess});
        txPulling.add((Lifecycle)batchingTxApplier);
        txPulling.add((Lifecycle)catchupProcess);
        txPulling.add((Lifecycle)new WaitForUpToDateStore(catchupProcess, logProvider));
        ExponentialBackoffStrategy retryStrategy = new ExponentialBackoffStrategy(1L, 30L, TimeUnit.SECONDS);
        life.add((Lifecycle)new ReadReplicaStartupProcess(remoteStore, localDatabase, (Lifecycle)txPulling, upstreamDatabaseStrategySelector, retryStrategy, logProvider, platformModule.logging.getUserLogProvider(), storeCopyProcess, topologyService));
        RegularCatchupServerHandler catchupServerHandler = new RegularCatchupServerHandler(platformModule.monitors, logProvider, localDatabase::storeId, platformModule.dependencies.provideDependency(TransactionIdStore.class), platformModule.dependencies.provideDependency(LogicalTransactionStore.class), localDatabase::dataSource, localDatabase::isAvailable, fileSystem, platformModule.storeCopyCheckPointMutex, null, new CheckpointerSupplier(platformModule.dependencies));
        InstalledProtocolHandler installedProtocolHandler = new InstalledProtocolHandler();
        Server catchupServer = new CatchupServerBuilder(catchupServerHandler).serverHandler((ChannelInboundHandler)installedProtocolHandler).catchupProtocols(supportedCatchupProtocols).modifierProtocols(supportedModifierProtocols).pipelineBuilder(serverPipelineBuilderFactory).userLogProvider(userLogProvider).debugLogProvider(logProvider).listenAddress((ListenSocketAddress)config.get(CausalClusteringSettings.transaction_listen_address)).serverName("catchup-server").build();
        TransactionBackupServiceProvider transactionBackupServiceProvider = new TransactionBackupServiceProvider(logProvider, userLogProvider, supportedCatchupProtocols, supportedModifierProtocols, backupServerPipelineBuilderFactory, catchupServerHandler, (ChannelInboundHandler)installedProtocolHandler);
        Optional<Server> backupCatchupServer = transactionBackupServiceProvider.resolveIfBackupEnabled(config);
        servicesToStopOnStoreCopy.add(catchupServer);
        backupCatchupServer.ifPresent(servicesToStopOnStoreCopy::add);
        dependencies.satisfyDependency((Object)this.createSessionTracker());
        life.add((Lifecycle)catchupServer);
        backupCatchupServer.ifPresent(arg_0 -> ((LifeSupport)life).add(arg_0));
    }

    private UpstreamDatabaseStrategySelector createUpstreamDatabaseStrategySelector(MemberId myself, Config config, LogProvider logProvider, TopologyService topologyService, ConnectToRandomCoreServerStrategy defaultStrategy) {
        UpstreamDatabaseStrategiesLoader loader;
        if (((Boolean)config.get(CausalClusteringSettings.multi_dc_license)).booleanValue()) {
            loader = new UpstreamDatabaseStrategiesLoader(topologyService, config, myself, logProvider);
            logProvider.getLog(((Object)((Object)this)).getClass()).info("Multi-Data Center option enabled.");
        } else {
            loader = new NoOpUpstreamDatabaseStrategiesLoader();
        }
        return new UpstreamDatabaseStrategySelector(defaultStrategy, loader, logProvider);
    }

    protected void configureDiscoveryService(DiscoveryServiceFactory discoveryServiceFactory, Dependencies dependencies, Config config, LogProvider logProvider) {
    }

    protected DuplexPipelineWrapperFactory pipelineWrapperFactory() {
        return new VoidPipelineWrapperFactory();
    }

    static Predicate<String> fileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db"), filename -> filename.startsWith("branched"), filename -> filename.startsWith("temp-copy"), filename -> filename.endsWith(".cacheprof")});
    }

    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
        procedures.register((CallableProcedure)new ReadReplicaRoleProcedure());
    }

    private void registerRecovery(DatabaseInfo databaseInfo, LifeSupport life, DependencyResolver dependencyResolver) {
        life.addLifecycleListener((instance, from, to) -> {
            if (instance instanceof DatabaseAvailability && to.equals((Object)LifecycleStatus.STARTED)) {
                this.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
            }
        });
    }

    private CommitProcessFactory readOnly() {
        return (appender, storageEngine, config) -> new ReadOnlyTransactionCommitProcess();
    }

    protected BoltConnectionTracker createSessionTracker() {
        return new StandardBoltConnectionTracker();
    }

    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.setupEnterpriseSecurityModule((PlatformModule)platformModule, (Procedures)procedures);
    }

    private static TopologyServiceRetryStrategy resolveStrategy(Config config, LogProvider logProvider) {
        long refreshPeriodMillis = ((Duration)config.get(CausalClusteringSettings.cluster_topology_refresh)).toMillis();
        int pollingFrequencyWithinRefreshWindow = 2;
        int numberOfRetries = pollingFrequencyWithinRefreshWindow + 1;
        return new TopologyServiceMultiRetryStrategy(refreshPeriodMillis / (long)pollingFrequencyWithinRefreshWindow, numberOfRetries, logProvider);
    }

    private LogFiles buildLocalDatabaseLogFiles(PlatformModule platformModule, FileSystemAbstraction fileSystem, File storeDir, Config config) {
        try {
            return LogFilesBuilder.activeFilesBuilder((File)storeDir, (FileSystemAbstraction)fileSystem, (PageCache)platformModule.pageCache).withConfig(config).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

