/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.routing.load_balancing.filters.Filter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.ServerInfo;
import org.neo4j.helpers.collection.Iterators;

public class AnyGroupFilter
implements Filter<ServerInfo> {
    private final Predicate<ServerInfo> matchesAnyGroup = serverInfo -> {
        for (String group : serverInfo.groups()) {
            if (!groups.contains(group)) continue;
            return true;
        }
        return false;
    };
    private final Set<String> groups;

    AnyGroupFilter(String ... groups) {
        this(Iterators.asSet((Object[])groups));
    }

    AnyGroupFilter(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    public Set<ServerInfo> apply(Set<ServerInfo> data) {
        return data.stream().filter(this.matchesAnyGroup).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyGroupFilter that = (AnyGroupFilter)o;
        return Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public String toString() {
        return "AnyGroupFilter{groups=" + this.groups + '}';
    }
}

