/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.procedure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.Role;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingResult;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.procedure.RoutingResultFormatHelper;
import org.neo4j.helpers.SocketAddress;

public class ResultFormatV1 {
    private static final String ROLE_KEY = "role";
    private static final String ADDRESSES_KEY = "addresses";

    private ResultFormatV1() {
    }

    static Object[] build(LoadBalancingProcessor.Result result) {
        TreeMap<String, Object> map;
        Object[] routers = result.routeEndpoints().stream().map(Endpoint::address).map(SocketAddress::toString).toArray();
        Object[] readers = result.readEndpoints().stream().map(Endpoint::address).map(SocketAddress::toString).toArray();
        Object[] writers = result.writeEndpoints().stream().map(Endpoint::address).map(SocketAddress::toString).toArray();
        ArrayList servers = new ArrayList();
        if (writers.length > 0) {
            map = new TreeMap<String, Object>();
            map.put(ROLE_KEY, Role.WRITE.name());
            map.put(ADDRESSES_KEY, writers);
            servers.add(map);
        }
        if (readers.length > 0) {
            map = new TreeMap();
            map.put(ROLE_KEY, Role.READ.name());
            map.put(ADDRESSES_KEY, readers);
            servers.add(map);
        }
        if (routers.length > 0) {
            map = new TreeMap();
            map.put(ROLE_KEY, Role.ROUTE.name());
            map.put(ADDRESSES_KEY, routers);
            servers.add(map);
        }
        long timeToLiveSeconds = TimeUnit.MILLISECONDS.toSeconds(result.ttlMillis());
        return new Object[]{timeToLiveSeconds, servers};
    }

    public static LoadBalancingResult parse(Object[] record) {
        long timeToLiveSeconds = (Long)record[0];
        List endpointData = (List)record[1];
        Map<Role, List<Endpoint>> endpoints = ResultFormatV1.parseRows(endpointData);
        return new LoadBalancingResult(endpoints.get((Object)Role.ROUTE), endpoints.get((Object)Role.WRITE), endpoints.get((Object)Role.READ), timeToLiveSeconds * 1000L);
    }

    public static LoadBalancingResult parse(Map<String, Object> record) {
        return ResultFormatV1.parse(new Object[]{record.get(ParameterNames.TTL.parameterName()), record.get(ParameterNames.SERVERS.parameterName())});
    }

    private static Map<Role, List<Endpoint>> parseRows(List<Map<String, Object>> result) {
        HashMap<Role, List<Endpoint>> endpoints = new HashMap<Role, List<Endpoint>>();
        for (Map<String, Object> single : result) {
            Role role = Role.valueOf((String)single.get(ROLE_KEY));
            List<Endpoint> addresses = RoutingResultFormatHelper.parseEndpoints((Object[])single.get(ADDRESSES_KEY), role);
            endpoints.put(role, addresses);
        }
        Arrays.stream(Role.values()).forEach(r -> endpoints.putIfAbsent((Role)((Object)r), Collections.emptyList()));
        return endpoints;
    }
}

