/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Map;
import java.util.Optional;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;

public class LeaderOnlyStrategy
extends UpstreamDatabaseSelectionStrategy {
    public static final String IDENTITY = "leader-only";

    public LeaderOnlyStrategy() {
        super(IDENTITY, new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        Map<MemberId, RoleInfo> memberRoles = this.topologyService.allCoreRoles();
        if (memberRoles.size() == 0) {
            throw new UpstreamDatabaseSelectionException("No core servers available");
        }
        for (Map.Entry<MemberId, RoleInfo> entry : memberRoles.entrySet()) {
            RoleInfo role = entry.getValue();
            if (role != RoleInfo.LEADER) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }
}

