/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.net.URI;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.StateMachines;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.statemachine.StateMachineConversations;
import org.neo4j.cluster.statemachine.StateMachineProxyFactory;
import org.neo4j.cluster.statemachine.StateTransitionListener;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.helpers.Listeners;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ProtocolServer
extends LifecycleAdapter
implements BindingNotifier {
    private final InstanceId me;
    private URI boundAt;
    protected StateMachineProxyFactory proxyFactory;
    protected final StateMachines stateMachines;
    private final Listeners<BindingListener> bindingListeners = new Listeners();
    private Log msgLog;

    public ProtocolServer(InstanceId me, StateMachines stateMachines, LogProvider logProvider) {
        this.me = me;
        this.stateMachines = stateMachines;
        this.msgLog = logProvider.getLog(this.getClass());
        StateMachineConversations conversations = new StateMachineConversations(me);
        this.proxyFactory = new StateMachineProxyFactory(stateMachines, conversations, me, logProvider);
        stateMachines.addMessageProcessor(this.proxyFactory);
    }

    public void shutdown() throws Throwable {
        this.msgLog = null;
    }

    @Override
    public void addBindingListener(BindingListener listener) {
        this.bindingListeners.add((Object)listener);
        try {
            if (this.boundAt != null) {
                listener.listeningAt(this.boundAt);
            }
        }
        catch (Throwable t) {
            this.msgLog.error("Failed while adding BindingListener", t);
        }
    }

    @Override
    public void removeBindingListener(BindingListener listener) {
        this.bindingListeners.remove((Object)listener);
    }

    public void listeningAt(URI me) {
        this.boundAt = me;
        this.bindingListeners.notify(listener -> listener.listeningAt(me));
    }

    public InstanceId getServerId() {
        return this.me;
    }

    public StateMachines getStateMachines() {
        return this.stateMachines;
    }

    public void addStateTransitionListener(StateTransitionListener stateTransitionListener) {
        this.stateMachines.addStateTransitionListener(stateTransitionListener);
    }

    public <T> T newClient(Class<T> clientProxyInterface) {
        return this.proxyFactory.newProxy(clientProxyInterface);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance URI: ").append(this.boundAt.toString()).append("\n");
        for (StateMachine stateMachine : this.stateMachines.getStateMachines()) {
            builder.append("  ").append(stateMachine).append("\n");
        }
        return builder.toString();
    }

    public Timeouts getTimeouts() {
        return this.stateMachines.getTimeouts();
    }

    public URI boundAt() {
        return this.boundAt;
    }
}

