/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.neo4j.cluster.protocol.atomicbroadcast.VersionMapper;

public class LenientObjectInputStream
extends ObjectInputStream {
    private VersionMapper versionMapper;

    public LenientObjectInputStream(ByteArrayInputStream fis, VersionMapper versionMapper) throws IOException {
        super(fis);
        this.versionMapper = versionMapper;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> localClass;
        ObjectStreamClass wireClassDescriptor = super.readClassDescriptor();
        if (!this.versionMapper.hasMappingFor(wireClassDescriptor.getName())) {
            this.versionMapper.addMappingFor(wireClassDescriptor.getName(), wireClassDescriptor.getSerialVersionUID());
        }
        try {
            localClass = Class.forName(wireClassDescriptor.getName());
        }
        catch (ClassNotFoundException e) {
            return wireClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSUID = localClassDescriptor.getSerialVersionUID();
            long wireSUID = wireClassDescriptor.getSerialVersionUID();
            if (wireSUID != localSUID) {
                wireClassDescriptor = localClassDescriptor;
            }
        }
        return wireClassDescriptor;
    }
}

