/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstance;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.statemachine.State;

public enum AcceptorState implements State<AcceptorContext, AcceptorMessage>
{
    start{

        public AcceptorState handle(AcceptorContext context, Message<AcceptorMessage> message, MessageHolder outgoing) throws Throwable {
            if (message.getMessageType() == AcceptorMessage.join) {
                return acceptor;
            }
            return this;
        }
    }
    ,
    acceptor{

        public AcceptorState handle(AcceptorContext context, Message<AcceptorMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case prepare: {
                    AcceptorMessage.PrepareState incomingState = (AcceptorMessage.PrepareState)message.getPayload();
                    InstanceId instanceId = new InstanceId(message);
                    AcceptorInstance localState = context.getAcceptorInstance(instanceId);
                    if (incomingState.getBallot() >= localState.getBallot()) {
                        context.promise(localState, incomingState.getBallot());
                        outgoing.offer(message.copyHeadersTo(Message.respond(ProposerMessage.promise, message, new ProposerMessage.PromiseState(incomingState.getBallot(), localState.getValue())), "instance"));
                        break;
                    }
                    context.getLog(AcceptorState.class).debug("Rejecting prepare from " + message.getHeader("from") + " for instance " + message.getHeader("instance") + " and ballot " + incomingState.getBallot() + " (i had a prepare state ballot = " + localState.getBallot() + ")");
                    outgoing.offer(message.copyHeadersTo(Message.respond(ProposerMessage.rejectPrepare, message, new ProposerMessage.RejectPrepare(localState.getBallot())), "instance"));
                    break;
                }
                case accept: {
                    AcceptorMessage.AcceptState acceptState = (AcceptorMessage.AcceptState)message.getPayload();
                    InstanceId instanceId = new InstanceId(message);
                    AcceptorInstance instance = context.getAcceptorInstance(instanceId);
                    if (acceptState.getBallot() == instance.getBallot()) {
                        context.accept(instance, acceptState.getValue());
                        instance.accept(acceptState.getValue());
                        outgoing.offer(message.copyHeadersTo(Message.respond(ProposerMessage.accepted, message, new ProposerMessage.AcceptedState()), "instance"));
                        break;
                    }
                    context.getLog(AcceptorState.class).debug("Reject " + instanceId + " accept ballot:" + acceptState.getBallot() + " actual ballot:" + instance.getBallot());
                    outgoing.offer(message.copyHeadersTo(Message.respond(ProposerMessage.rejectAccept, message, new ProposerMessage.RejectAcceptState()), "instance"));
                    break;
                }
                case leave: {
                    context.leave();
                    return start;
                }
            }
            return this;
        }
    };

}

