/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;
import org.neo4j.cluster.statemachine.State;

public enum AtomicBroadcastState implements State<AtomicBroadcastContext, AtomicBroadcastMessage>
{
    start{

        public AtomicBroadcastState handle(AtomicBroadcastContext context, Message<AtomicBroadcastMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case entered: {
                    return broadcasting;
                }
                case join: {
                    return joining;
                }
            }
            AtomicBroadcastState.defaultHandling(context, message);
            return this;
        }
    }
    ,
    joining{

        @Override
        public State<?, ?> handle(AtomicBroadcastContext context, Message<AtomicBroadcastMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case failed: {
                    outgoing.offer(Message.internal(ClusterMessage.joinFailure, new TimeoutException("Could not join cluster")));
                    return start;
                }
                case broadcastResponse: {
                    if (!(message.getPayload() instanceof ClusterMessage.ConfigurationChangeState)) break;
                    outgoing.offer(message.copyHeadersTo(Message.internal(ClusterMessage.configurationChanged, message.getPayload()), new String[0]));
                    break;
                }
                case entered: {
                    return broadcasting;
                }
                default: {
                    AtomicBroadcastState.defaultHandling(context, message);
                }
            }
            return this;
        }
    }
    ,
    broadcasting{

        public AtomicBroadcastState handle(AtomicBroadcastContext context, Message<AtomicBroadcastMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case failed: 
                case broadcast: {
                    if (context.hasQuorum()) {
                        InstanceId coordinator = context.getCoordinator();
                        if (coordinator != null) {
                            URI coordinatorUri = context.getUriForId(coordinator);
                            outgoing.offer(message.copyHeadersTo(Message.to(ProposerMessage.propose, coordinatorUri, message.getPayload()), new String[0]));
                            context.setTimeout("broadcast-" + message.getHeader("conversation-id"), Message.timeout(AtomicBroadcastMessage.broadcastTimeout, message, message.getPayload()));
                            break;
                        }
                        outgoing.offer(message.copyHeadersTo(Message.internal(ProposerMessage.propose, message.getPayload()), "conversation-id", "instance"));
                        break;
                    }
                    context.getLog(AtomicBroadcastState.class).warn("No quorum and therefor dropping broadcast msg: " + message.getPayload());
                    break;
                }
                case broadcastResponse: {
                    context.cancelTimeout("broadcast-" + message.getHeader("conversation-id"));
                    if (message.getPayload() instanceof ClusterMessage.ConfigurationChangeState) {
                        outgoing.offer(message.copyHeadersTo(Message.internal(ClusterMessage.configurationChanged, message.getPayload()), new String[0]));
                        ClusterMessage.ConfigurationChangeState change = (ClusterMessage.ConfigurationChangeState)message.getPayload();
                        if (change.getJoinUri() == null) break;
                        outgoing.offer(message.copyHeadersTo(Message.internal(HeartbeatMessage.i_am_alive, new HeartbeatMessage.IAmAliveState(change.getJoin())), "from"));
                        break;
                    }
                    context.receive((Payload)message.getPayload());
                    break;
                }
                case broadcastTimeout: {
                    break;
                }
                case leave: {
                    return start;
                }
                default: {
                    AtomicBroadcastState.defaultHandling(context, message);
                }
            }
            return this;
        }
    };


    private static void defaultHandling(AtomicBroadcastContext context, Message<AtomicBroadcastMessage> message) {
        switch (message.getMessageType()) {
            case addAtomicBroadcastListener: {
                context.addAtomicBroadcastListener((AtomicBroadcastListener)message.getPayload());
                break;
            }
            case removeAtomicBroadcastListener: {
                context.removeAtomicBroadcastListener((AtomicBroadcastListener)message.getPayload());
                break;
            }
        }
    }
}

