/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.io.Serializable;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;

public enum ProposerMessage implements MessageType
{
    join,
    leave,
    phase1Timeout,
    propose,
    promise,
    rejectPrepare,
    rejectPropose2,
    phase2Timeout,
    accepted,
    rejectAccept;


    public static class AcceptedState
    implements Serializable {
        private static final long serialVersionUID = 7637829269471254916L;

        public boolean equals(Object obj) {
            return obj instanceof AcceptedState;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class RejectAcceptState
    implements Serializable {
        private static final long serialVersionUID = -7885247643311510986L;

        public boolean equals(Object obj) {
            return obj instanceof RejectAcceptState;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class RejectPrepare
    implements Serializable {
        private static final long serialVersionUID = -7876771047186067963L;
        private long ballot;

        public RejectPrepare(long ballot) {
            this.ballot = ballot;
        }

        public long getBallot() {
            return this.ballot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RejectPrepare that = (RejectPrepare)o;
            return this.ballot == that.ballot;
        }

        public int hashCode() {
            return (int)(this.ballot ^ this.ballot >>> 32);
        }

        public String toString() {
            return "RejectPrepare{ballot=" + this.ballot + "}";
        }
    }

    public static class PromiseState
    implements Serializable {
        private static final long serialVersionUID = -7601846656107583813L;
        private long ballot;
        private Object value;

        public PromiseState(long ballot, Object value) {
            this.ballot = ballot;
            this.value = value;
        }

        public long getBallot() {
            return this.ballot;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            Object toStringValue = this.value;
            if (toStringValue instanceof Payload) {
                try {
                    toStringValue = new AtomicBroadcastSerializer(new ObjectStreamFactory(), new ObjectStreamFactory()).receive((Payload)toStringValue);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return "PromiseState{ballot=" + this.ballot + ", value=" + toStringValue + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PromiseState that = (PromiseState)o;
            if (this.ballot != that.ballot) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = (int)(this.ballot ^ this.ballot >>> 32);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

