/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstance;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.statemachine.State;

public enum ProposerState implements State<ProposerContext, ProposerMessage>
{
    start{

        public ProposerState handle(ProposerContext context, Message<ProposerMessage> message, MessageHolder outgoing) throws Throwable {
            if (message.getMessageType() == ProposerMessage.join) {
                return proposer;
            }
            return this;
        }
    }
    ,
    proposer{

        public ProposerState handle(ProposerContext context, Message<ProposerMessage> message, MessageHolder outgoing) throws Throwable {
            switch (message.getMessageType()) {
                case propose: {
                    ProposerState.propose(context, message, outgoing, ProposerState.determineAcceptorSet(message, context));
                    break;
                }
                case rejectPrepare: {
                    long ballot;
                    ProposerMessage.RejectPrepare rejectPropose = (ProposerMessage.RejectPrepare)message.getPayload();
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    context.getLog(ProposerState.class).debug("Propose for instance " + instance + " rejected from " + message.getHeader("from") + " with ballot " + rejectPropose.getBallot());
                    if (!instance.isState(PaxosInstance.State.p1_pending) || instance.getBallot() >= rejectPropose.getBallot()) break;
                    for (ballot = instance.ballot; ballot <= rejectPropose.getBallot(); ballot += 1000L) {
                    }
                    instance.phase1Timeout(ballot);
                    context.getLog(ProposerState.class).debug("Reproposing instance " + instance + " at ballot " + instance.ballot + " after rejectPrepare");
                    for (URI acceptor : instance.getAcceptors()) {
                        outgoing.offer(message.copyHeadersTo(Message.to(AcceptorMessage.prepare, acceptor, new AcceptorMessage.PrepareState(ballot)), "instance"));
                    }
                    assert (instance.value_1 == null) : "value_1 should have been null at this point";
                    Object payload = context.getBookedInstance(instanceId).getPayload();
                    assert (payload != null) : "Should have a booked instance payload for " + instanceId;
                    context.setTimeout(instanceId, message.copyHeadersTo(Message.timeout(ProposerMessage.phase1Timeout, message, payload), "instance"));
                    break;
                }
                case phase1Timeout: {
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    if (instance.isState(PaxosInstance.State.p1_pending)) {
                        if (instance.ballot > 10000L) {
                            context.getLog(ProposerState.class).warn("Propose failed due to phase 1 timeout");
                            Message originalMessage = context.getBookedInstance(instance.id);
                            outgoing.offer(originalMessage.copyHeadersTo(Message.internal(AtomicBroadcastMessage.failed, originalMessage.getPayload()), new String[0]));
                            context.cancelTimeout(instanceId);
                            break;
                        }
                        long ballot = instance.ballot + 1000L;
                        instance.phase1Timeout(ballot);
                        for (URI acceptor : instance.getAcceptors()) {
                            outgoing.offer(message.copyHeadersTo(Message.to(AcceptorMessage.prepare, acceptor, new AcceptorMessage.PrepareState(ballot)), "instance"));
                        }
                        context.setTimeout(instanceId, message.copyHeadersTo(Message.timeout(ProposerMessage.phase1Timeout, message, message.getPayload()), "instance"));
                        break;
                    }
                    if (!instance.isState(PaxosInstance.State.closed) && !instance.isState(PaxosInstance.State.delivered)) break;
                    Message<ProposerMessage> oldMessage = context.unbookInstance(instance.id);
                    context.getLog(this.getClass()).debug("Retrying instance " + instance.id + " with message " + message.getPayload() + ". Previous instance was " + oldMessage);
                    outgoing.offer(Message.internal(ProposerMessage.propose, message.getPayload()));
                    break;
                }
                case promise: {
                    Object readyValue;
                    ProposerMessage.PromiseState promiseState = (ProposerMessage.PromiseState)message.getPayload();
                    PaxosInstance instance = context.getPaxosInstance(new InstanceId(message));
                    if (!instance.isState(PaxosInstance.State.p1_pending) || instance.ballot != promiseState.getBallot()) break;
                    instance.promise(promiseState);
                    if (!instance.isPromised(context.getMinimumQuorumSize(instance.getAcceptors()))) break;
                    context.cancelTimeout(instance.id);
                    Object object = readyValue = instance.value_2 == null ? context.getBookedInstance(instance.id).getPayload() : instance.value_2;
                    if (instance.value_1 == null) {
                        instance.ready(readyValue, true);
                    } else if (instance.value_2 == null) {
                        context.pendingValue(context.unbookInstance(instance.id));
                        instance.ready(instance.value_1, false);
                    } else if (instance.value_1.equals(readyValue)) {
                        instance.ready(instance.value_2, instance.clientValue);
                    } else if (instance.clientValue) {
                        context.pendingValue(context.unbookInstance(instance.id));
                        instance.ready(instance.value_1, false);
                    } else {
                        context.pendingValue(context.unbookInstance(instance.id));
                        instance.ready(instance.value_1, false);
                    }
                    instance.pending();
                    for (URI acceptor : instance.getAcceptors()) {
                        outgoing.offer(message.copyHeadersTo(Message.to(AcceptorMessage.accept, acceptor, new AcceptorMessage.AcceptState(instance.ballot, instance.value_2)), "instance"));
                    }
                    context.setTimeout(instance.id, message.copyHeadersTo(Message.timeout(ProposerMessage.phase2Timeout, message, readyValue), "instance"));
                    break;
                }
                case rejectAccept: {
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    if (!instance.isState(PaxosInstance.State.p2_pending)) break;
                    ProposerMessage.RejectAcceptState state = (ProposerMessage.RejectAcceptState)message.getPayload();
                    instance.rejected(state);
                    if (instance.isAccepted(context.getMinimumQuorumSize(instance.getAcceptors()))) break;
                    context.cancelTimeout(instanceId);
                    context.getLog(ProposerState.class).warn("Accept rejected:" + (Object)((Object)instance.state));
                    if (!instance.clientValue) break;
                    Message<ProposerMessage> copyWithValue = Message.internal(ProposerMessage.propose, instance.value_2);
                    message.copyHeadersTo(copyWithValue, new String[0]);
                    ProposerState.propose(context, copyWithValue, outgoing, instance.getAcceptors());
                    break;
                }
                case phase2Timeout: {
                    InstanceId instanceId = new InstanceId(message);
                    PaxosInstance instance = context.getPaxosInstance(instanceId);
                    if (instance.isState(PaxosInstance.State.p2_pending)) {
                        long ballot = instance.ballot + 1000L;
                        instance.phase2Timeout(ballot);
                        for (URI acceptor : instance.getAcceptors()) {
                            outgoing.offer(message.copyHeadersTo(Message.to(AcceptorMessage.prepare, acceptor, new AcceptorMessage.PrepareState(ballot)), "instance"));
                        }
                        context.setTimeout(instanceId, message.copyHeadersTo(Message.timeout(ProposerMessage.phase1Timeout, message, message.getPayload()), "instance"));
                        break;
                    }
                    if (!instance.isState(PaxosInstance.State.closed) && !instance.isState(PaxosInstance.State.delivered)) break;
                    outgoing.offer(message.copyHeadersTo(Message.internal(ProposerMessage.propose, message.getPayload()), new String[0]));
                    break;
                }
                case accepted: {
                    PaxosInstance instance = context.getPaxosInstance(new InstanceId(message));
                    if (instance.isState(PaxosInstance.State.p2_pending)) {
                        ProposerMessage.AcceptedState acceptedState = (ProposerMessage.AcceptedState)message.getPayload();
                        instance.accepted(acceptedState);
                        if (instance.accepts.size() < context.getMinimumQuorumSize(instance.getAcceptors())) break;
                        context.cancelTimeout(instance.id);
                        if (instance.value_2 instanceof ClusterMessage.ConfigurationChangeState) {
                            context.patchBookedInstances((ClusterMessage.ConfigurationChangeState)instance.value_2);
                            ClusterMessage.ConfigurationChangeState state = (ClusterMessage.ConfigurationChangeState)instance.value_2;
                            for (URI learner : context.getMemberURIs()) {
                                if (learner.equals(context.boundAt())) {
                                    outgoing.offer(message.copyHeadersTo(Message.internal(LearnerMessage.learn, new LearnerMessage.LearnState(instance.value_2)), "instance"));
                                    continue;
                                }
                                outgoing.offer(message.copyHeadersTo(Message.to(LearnerMessage.learn, learner, new LearnerMessage.LearnState(instance.value_2)), "instance"));
                            }
                            if (state.getJoin() != null) {
                                outgoing.offer(message.copyHeadersTo(Message.to(LearnerMessage.learn, state.getJoinUri(), new LearnerMessage.LearnState(instance.value_2)), "instance"));
                            }
                        } else {
                            for (URI learner : context.getMemberURIs()) {
                                outgoing.offer(message.copyHeadersTo(Message.to(LearnerMessage.learn, learner, new LearnerMessage.LearnState(instance.value_2)), "instance"));
                            }
                        }
                        context.unbookInstance(instance.id);
                        if (!context.hasPendingValues() || !context.canBookInstance()) break;
                        Message proposeMessage = context.popPendingValue();
                        context.getLog(ProposerState.class).debug("Restarting " + proposeMessage + " booked:" + context.nrOfBookedInstances());
                        outgoing.offer(proposeMessage);
                        break;
                    }
                    context.getLog(ProposerState.class).debug("Instance receiving an accepted is in the wrong state:" + instance);
                    break;
                }
                case leave: {
                    context.leave();
                    return start;
                }
            }
            return this;
        }
    };


    private static void propose(ProposerContext context, Message message, MessageHolder outgoing, List<URI> acceptors) {
        InstanceId instanceId;
        if (message.hasHeader("instance")) {
            instanceId = new InstanceId(message);
        } else {
            instanceId = context.newInstanceId();
            message.setHeader("instance", instanceId.toString());
            context.bookInstance(instanceId, message);
        }
        long ballot = 1000 + context.getMyId().toIntegerIndex();
        PaxosInstance instance = context.getPaxosInstance(instanceId);
        if (instance.getAcceptors() != null) {
            acceptors = instance.getAcceptors();
        }
        if (!instance.isState(PaxosInstance.State.closed) && !instance.isState(PaxosInstance.State.delivered)) {
            instance.propose(ballot, acceptors);
            for (URI acceptor : acceptors) {
                outgoing.offer(Message.to(AcceptorMessage.prepare, acceptor, new AcceptorMessage.PrepareState(ballot)).setHeader("instance", instanceId.toString()));
            }
            context.setTimeout(instanceId, Message.timeout(ProposerMessage.phase1Timeout, message, message.getPayload()).setHeader("instance", instanceId.toString()));
        } else {
            context.pendingValue(message);
        }
    }

    private static List<URI> determineAcceptorSet(Message<ProposerMessage> message, ProposerContext context) {
        Object payload = message.getPayload();
        if (payload instanceof ClusterMessage.ConfigurationChangeState) {
            ClusterMessage.ConfigurationChangeState state = (ClusterMessage.ConfigurationChangeState)message.getPayload();
            List<URI> acceptors = context.getAcceptors();
            Map<org.neo4j.cluster.InstanceId, URI> currentMembers = context.getMembers();
            if (state.getLeave() != null) {
                acceptors = new ArrayList<URI>(acceptors);
                acceptors.remove(currentMembers.get(state.getLeave()));
            }
            if (state.getJoin() != null && currentMembers.containsKey(state.getJoin())) {
                acceptors.remove(currentMembers.get(state.getJoin()));
                if (!acceptors.contains(state.getJoinUri())) {
                    acceptors.add(state.getJoinUri());
                }
            }
            return acceptors;
        }
        return context.getAcceptors();
    }
}

