/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AbstractContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;

class HeartbeatContextImpl
extends AbstractContextImpl
implements HeartbeatContext {
    private Set<InstanceId> failed = new HashSet<InstanceId>();
    private Map<InstanceId, Set<InstanceId>> nodeSuspicions = new HashMap<InstanceId, Set<InstanceId>>();
    private final Listeners<HeartbeatListener> heartBeatListeners;
    private final Executor executor;
    private ClusterContext clusterContext;
    private LearnerContext learnerContext;

    HeartbeatContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Executor executor) {
        super(me, commonState, logging, timeouts);
        this.executor = executor;
        this.heartBeatListeners = new Listeners();
    }

    private HeartbeatContextImpl(InstanceId me, CommonContextState commonState, LogProvider logging, Timeouts timeouts, Set<InstanceId> failed, Map<InstanceId, Set<InstanceId>> nodeSuspicions, Listeners<HeartbeatListener> heartBeatListeners, Executor executor) {
        super(me, commonState, logging, timeouts);
        this.failed = failed;
        this.nodeSuspicions = nodeSuspicions;
        this.heartBeatListeners = heartBeatListeners;
        this.executor = executor;
    }

    void setCircularDependencies(ClusterContext clusterContext, LearnerContext learnerContext) {
        this.clusterContext = clusterContext;
        this.learnerContext = learnerContext;
    }

    @Override
    public void started() {
        this.failed.clear();
    }

    @Override
    public boolean alive(InstanceId node) {
        Set<InstanceId> serverSuspicions = this.suspicionsFor(this.getMyId());
        boolean suspected = serverSuspicions.remove(node);
        if (!this.isFailed(node) && this.failed.remove(node)) {
            this.getLog((Class)HeartbeatContext.class).info("Notifying listeners that instance " + node + " is alive");
            this.heartBeatListeners.notify(this.executor, listener -> listener.alive(node));
        }
        return suspected;
    }

    @Override
    public void suspect(InstanceId node) {
        Set<InstanceId> serverSuspicions = this.suspicionsFor(this.getMyId());
        if (!serverSuspicions.contains(node)) {
            serverSuspicions.add(node);
            this.getLog((Class)HeartbeatContext.class).info(this.getMyId() + "(me) is now suspecting " + node);
        }
        if (this.isFailed(node) && !this.failed.contains(node)) {
            this.getLog((Class)HeartbeatContext.class).info("Notifying listeners that instance " + node + " is failed");
            this.failed.add(node);
            this.heartBeatListeners.notify(this.executor, listener -> listener.failed(node));
        }
        if (this.checkSuspectEverybody()) {
            this.getLog((Class)HeartbeatContext.class).warn("All other instances are being suspected. Moving on to mark all other instances as failed");
            this.markAllOtherMembersAsFailed();
        }
    }

    private void markAllOtherMembersAsFailed() {
        HashSet<InstanceId> everyoneElse = new HashSet<InstanceId>();
        for (InstanceId instanceId : this.getMembers().keySet()) {
            if (this.isMe(instanceId)) continue;
            everyoneElse.add(instanceId);
        }
        for (InstanceId instanceId : everyoneElse) {
            HashSet<InstanceId> instancesThisInstanceSuspects = new HashSet<InstanceId>(everyoneElse);
            instancesThisInstanceSuspects.remove(instanceId);
            this.suspicions(instanceId, instancesThisInstanceSuspects);
        }
    }

    private boolean checkSuspectEverybody() {
        Map<InstanceId, URI> allClusterMembers = this.getMembers();
        Set<InstanceId> suspectedInstances = this.getSuspicionsFor(this.getMyId());
        int suspected = 0;
        for (InstanceId suspectedInstance : suspectedInstances) {
            if (!allClusterMembers.containsKey(suspectedInstance)) continue;
            ++suspected;
        }
        return suspected == allClusterMembers.size() - 1;
    }

    @Override
    public void suspicions(InstanceId from, Set<InstanceId> suspicions) {
        if (this.isFailed(from) && !this.failed.contains(from)) {
            this.getLog((Class)HeartbeatContext.class).info("Ignoring suspicions from failed instance " + from + ": " + Iterables.toString(suspicions, (String)","));
            return;
        }
        Set<InstanceId> serverSuspicions = this.suspicionsFor(from);
        Iterator<InstanceId> suspicionsIterator = serverSuspicions.iterator();
        while (suspicionsIterator.hasNext()) {
            InstanceId currentSuspicion = suspicionsIterator.next();
            if (suspicions.contains(currentSuspicion)) continue;
            this.getLog((Class)HeartbeatContext.class).info(from + " is no longer suspecting " + currentSuspicion);
            suspicionsIterator.remove();
        }
        for (InstanceId suspicion : suspicions) {
            if (serverSuspicions.contains(suspicion)) continue;
            this.getLog((Class)HeartbeatContext.class).info(from + " is now suspecting " + suspicion);
            serverSuspicions.add(suspicion);
        }
        for (InstanceId node : suspicions) {
            if (!this.isFailed(node) || this.failed.contains(node)) continue;
            this.failed.add(node);
            this.heartBeatListeners.notify(this.executor, listener -> listener.failed(node));
        }
    }

    @Override
    public Set<InstanceId> getFailed() {
        return this.failed;
    }

    @Override
    public Iterable<InstanceId> getAlive() {
        return Iterables.filter(item -> !this.isFailed((InstanceId)item), this.commonState.configuration().getMemberIds());
    }

    @Override
    public void addHeartbeatListener(HeartbeatListener listener) {
        this.heartBeatListeners.add((Object)listener);
    }

    @Override
    public void removeHeartbeatListener(HeartbeatListener listener) {
        this.heartBeatListeners.remove((Object)listener);
    }

    @Override
    public void serverLeftCluster(InstanceId node) {
        this.failed.remove(node);
        for (Set<InstanceId> uris : this.nodeSuspicions.values()) {
            uris.remove(node);
        }
    }

    @Override
    public boolean isFailed(InstanceId node) {
        List<InstanceId> suspicionsForNode = this.getSuspicionsOf(node);
        int countOfInstancesSuspectedByMe = this.getSuspicionsFor(this.getMyId()).size();
        return suspicionsForNode.size() > (this.commonState.configuration().getMembers().size() - countOfInstancesSuspectedByMe) / 2;
    }

    @Override
    public List<InstanceId> getSuspicionsOf(InstanceId instanceId) {
        ArrayList<InstanceId> suspicions = new ArrayList<InstanceId>();
        for (InstanceId member : this.commonState.configuration().getMemberIds()) {
            Set<InstanceId> memberSuspicions = this.nodeSuspicions.get(member);
            if (memberSuspicions == null || this.failed.contains(member) || !memberSuspicions.contains(instanceId)) continue;
            suspicions.add(member);
        }
        return suspicions;
    }

    @Override
    public Set<InstanceId> getSuspicionsFor(InstanceId instanceId) {
        Set<InstanceId> suspicions = this.suspicionsFor(instanceId);
        return new HashSet<InstanceId>(suspicions);
    }

    private Set<InstanceId> suspicionsFor(InstanceId instanceId) {
        Set<InstanceId> serverSuspicions = this.nodeSuspicions.get(instanceId);
        if (serverSuspicions == null) {
            serverSuspicions = new HashSet<InstanceId>();
            this.nodeSuspicions.put(instanceId, serverSuspicions);
        }
        return serverSuspicions;
    }

    @Override
    public Iterable<InstanceId> getOtherInstances() {
        return this.clusterContext.getOtherInstances();
    }

    @Override
    public long getLastKnownLearnedInstanceInCluster() {
        return this.learnerContext.getLastKnownLearnedInstanceInCluster();
    }

    @Override
    public long getLastLearnedInstanceId() {
        return this.learnerContext.getLastLearnedInstanceId();
    }

    public HeartbeatContextImpl snapshot(CommonContextState commonStateSnapshot, LogProvider logging, Timeouts timeouts, Executor executor) {
        return new HeartbeatContextImpl(this.me, commonStateSnapshot, logging, timeouts, new HashSet<InstanceId>(this.failed), new HashMap<InstanceId, Set<InstanceId>>(this.nodeSuspicions), (Listeners<HeartbeatListener>)new Listeners(this.heartBeatListeners), executor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeartbeatContextImpl that = (HeartbeatContextImpl)o;
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        return !(this.nodeSuspicions != null ? !this.nodeSuspicions.equals(that.nodeSuspicions) : that.nodeSuspicions != null);
    }

    public int hashCode() {
        int result = this.failed != null ? this.failed.hashCode() : 0;
        result = 31 * result + (this.nodeSuspicions != null ? this.nodeSuspicions.hashCode() : 0);
        return result;
    }
}

