/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.util.concurrent.Executor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.PaxosInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AcceptorContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.AtomicBroadcastContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.ClusterContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.ElectionContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.HeartbeatContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.LearnerContextImpl;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.ProposerContextImpl;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.election.ElectionContext;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ElectionRole;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.logging.LogProvider;

public class MultiPaxosContext {
    private final ClusterContextImpl clusterContext;
    private final ProposerContextImpl proposerContext;
    private final AcceptorContextImpl acceptorContext;
    private final LearnerContextImpl learnerContext;
    private final HeartbeatContextImpl heartbeatContext;
    private final ElectionContextImpl electionContext;
    private final AtomicBroadcastContextImpl atomicBroadcastContext;
    private final CommonContextState commonState;
    private final PaxosInstanceStore paxosInstances;

    public MultiPaxosContext(InstanceId me, int maxAcceptors, Iterable<ElectionRole> roles, ClusterConfiguration configuration, Executor executor, LogProvider logging, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, AcceptorInstanceStore instanceStore, Timeouts timeouts, ElectionCredentialsProvider electionCredentialsProvider) {
        this.commonState = new CommonContextState(configuration, maxAcceptors);
        this.paxosInstances = new PaxosInstanceStore();
        this.heartbeatContext = new HeartbeatContextImpl(me, this.commonState, logging, timeouts, executor);
        this.learnerContext = new LearnerContextImpl(me, this.commonState, logging, timeouts, this.paxosInstances, instanceStore, objectInputStreamFactory, objectOutputStreamFactory, this.heartbeatContext);
        this.clusterContext = new ClusterContextImpl(me, this.commonState, logging, timeouts, executor, objectOutputStreamFactory, objectInputStreamFactory, this.learnerContext, this.heartbeatContext);
        this.electionContext = new ElectionContextImpl(me, this.commonState, logging, timeouts, roles, this.clusterContext, this.heartbeatContext, electionCredentialsProvider);
        this.proposerContext = new ProposerContextImpl(me, this.commonState, logging, timeouts, this.paxosInstances, this.heartbeatContext);
        this.acceptorContext = new AcceptorContextImpl(me, this.commonState, logging, timeouts, instanceStore);
        this.atomicBroadcastContext = new AtomicBroadcastContextImpl(me, this.commonState, logging, timeouts, executor, this.heartbeatContext);
        this.heartbeatContext.setCircularDependencies(this.clusterContext, this.learnerContext);
    }

    private MultiPaxosContext(ProposerContextImpl proposerContext, AcceptorContextImpl acceptorContext, LearnerContextImpl learnerContext, HeartbeatContextImpl heartbeatContext, ElectionContextImpl electionContext, AtomicBroadcastContextImpl atomicBroadcastContext, CommonContextState commonState, PaxosInstanceStore paxosInstances, ClusterContextImpl clusterContext) {
        this.clusterContext = clusterContext;
        this.proposerContext = proposerContext;
        this.acceptorContext = acceptorContext;
        this.learnerContext = learnerContext;
        this.heartbeatContext = heartbeatContext;
        this.electionContext = electionContext;
        this.atomicBroadcastContext = atomicBroadcastContext;
        this.commonState = commonState;
        this.paxosInstances = paxosInstances;
    }

    public ClusterContext getClusterContext() {
        return this.clusterContext;
    }

    public ProposerContext getProposerContext() {
        return this.proposerContext;
    }

    public AcceptorContext getAcceptorContext() {
        return this.acceptorContext;
    }

    public LearnerContext getLearnerContext() {
        return this.learnerContext;
    }

    public HeartbeatContext getHeartbeatContext() {
        return this.heartbeatContext;
    }

    public ElectionContext getElectionContext() {
        return this.electionContext;
    }

    public AtomicBroadcastContextImpl getAtomicBroadcastContext() {
        return this.atomicBroadcastContext;
    }

    public MultiPaxosContext snapshot(LogProvider logging, Timeouts timeouts, Executor executor, AcceptorInstanceStore instanceStore, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, ElectionCredentialsProvider electionCredentialsProvider) {
        CommonContextState commonStateSnapshot = this.commonState.snapshot(logging.getLog(ClusterConfiguration.class));
        PaxosInstanceStore paxosInstancesSnapshot = this.paxosInstances.snapshot();
        HeartbeatContextImpl snapshotHeartbeatContext = this.heartbeatContext.snapshot(commonStateSnapshot, logging, timeouts, executor);
        LearnerContextImpl snapshotLearnerContext = this.learnerContext.snapshot(commonStateSnapshot, logging, timeouts, paxosInstancesSnapshot, instanceStore, objectInputStreamFactory, objectOutputStreamFactory, snapshotHeartbeatContext);
        ClusterContextImpl snapshotClusterContext = this.clusterContext.snapshot(commonStateSnapshot, logging, timeouts, executor, objectOutputStreamFactory, objectInputStreamFactory, snapshotLearnerContext, snapshotHeartbeatContext);
        ElectionContextImpl snapshotElectionContext = this.electionContext.snapshot(commonStateSnapshot, logging, timeouts, snapshotClusterContext, snapshotHeartbeatContext, electionCredentialsProvider);
        ProposerContextImpl snapshotProposerContext = this.proposerContext.snapshot(commonStateSnapshot, logging, timeouts, paxosInstancesSnapshot, this.heartbeatContext);
        AcceptorContextImpl snapshotAcceptorContext = this.acceptorContext.snapshot(commonStateSnapshot, logging, timeouts, instanceStore);
        AtomicBroadcastContextImpl snapshotAtomicBroadcastContext = this.atomicBroadcastContext.snapshot(commonStateSnapshot, logging, timeouts, executor, snapshotHeartbeatContext);
        snapshotHeartbeatContext.setCircularDependencies(snapshotClusterContext, snapshotLearnerContext);
        return new MultiPaxosContext(snapshotProposerContext, snapshotAcceptorContext, snapshotLearnerContext, snapshotHeartbeatContext, snapshotElectionContext, snapshotAtomicBroadcastContext, commonStateSnapshot, paxosInstancesSnapshot, snapshotClusterContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPaxosContext that = (MultiPaxosContext)o;
        if (!this.acceptorContext.equals(that.acceptorContext)) {
            return false;
        }
        if (!this.atomicBroadcastContext.equals(that.atomicBroadcastContext)) {
            return false;
        }
        if (!this.clusterContext.equals(that.clusterContext)) {
            return false;
        }
        if (!this.commonState.equals(that.commonState)) {
            return false;
        }
        if (!this.electionContext.equals(that.electionContext)) {
            return false;
        }
        if (!this.heartbeatContext.equals(that.heartbeatContext)) {
            return false;
        }
        if (!this.learnerContext.equals(that.learnerContext)) {
            return false;
        }
        if (!this.paxosInstances.equals(that.paxosInstances)) {
            return false;
        }
        return this.proposerContext.equals(that.proposerContext);
    }

    public int hashCode() {
        int result = this.clusterContext.hashCode();
        result = 31 * result + this.proposerContext.hashCode();
        result = 31 * result + this.acceptorContext.hashCode();
        result = 31 * result + this.learnerContext.hashCode();
        result = 31 * result + this.heartbeatContext.hashCode();
        result = 31 * result + this.electionContext.hashCode();
        result = 31 * result + this.atomicBroadcastContext.hashCode();
        result = 31 * result + this.commonState.hashCode();
        result = 31 * result + this.paxosInstances.hashCode();
        return result;
    }
}

