/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.election;

import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class HeartbeatReelectionListener
implements HeartbeatListener {
    private final Election election;
    private final Log log;

    public HeartbeatReelectionListener(Election election, LogProvider logProvider) {
        this.election = election;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void failed(InstanceId server) {
        this.log.warn(" instance " + server + " is being demoted since it failed");
        this.election.demote(server);
    }

    @Override
    public void alive(InstanceId server) {
        this.election.performRoleElections();
    }
}

