/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.heartbeat;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class HeartbeatLeftListener
extends ClusterListener.Adapter {
    private final HeartbeatContext heartbeatContext;
    private final Log log;

    public HeartbeatLeftListener(HeartbeatContext heartbeatContext, LogProvider logProvider) {
        this.heartbeatContext = heartbeatContext;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void leftCluster(InstanceId instanceId, URI member) {
        if (this.heartbeatContext.isFailed(instanceId)) {
            this.log.warn("Instance " + instanceId + " (" + member + ") has left the cluster but is still treated as failed by HeartbeatContext");
            this.heartbeatContext.serverLeftCluster(instanceId);
        }
    }
}

