/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.logging.Log;

public class HaConfigurationValidator
implements ConfigurationValidator {
    @Nonnull
    public Map<String, String> validate(@Nonnull Collection<SettingValidator> settingValidators, @Nonnull Map<String, String> rawConfig, @Nonnull Log log, boolean parsingFile) throws InvalidSettingException {
        ClusterSettings.Mode mode = (ClusterSettings.Mode)((Object)ClusterSettings.mode.apply(rawConfig::get));
        if (!mode.equals((Object)ClusterSettings.Mode.HA) && !mode.equals((Object)ClusterSettings.Mode.ARBITER)) {
            return rawConfig;
        }
        HaConfigurationValidator.validateServerId(rawConfig::get);
        HaConfigurationValidator.validateInitialHosts(rawConfig::get);
        return rawConfig;
    }

    private static void validateServerId(Function<String, String> provider) {
        if (ClusterSettings.server_id.apply(provider) == null) {
            throw new InvalidSettingException(String.format("Missing mandatory value for '%s'", ClusterSettings.server_id.name()));
        }
    }

    private static void validateInitialHosts(Function<String, String> provider) {
        List hosts = (List)ClusterSettings.initial_hosts.apply(provider);
        if (hosts == null || hosts.isEmpty()) {
            throw new InvalidSettingException(String.format("Missing mandatory non-empty value for '%s'", ClusterSettings.initial_hosts.name()));
        }
    }
}

