/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.codegen.Binding;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.MethodTemplate;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.Resource;
import org.neo4j.codegen.TryBlock;
import org.neo4j.codegen.TypeReference;

public class CodeGenerationTest {
    public static final MethodReference RUN = MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]);
    private static final String PACKAGE = "org.neo4j.codegen.test";
    private final CodeGenerator generator;

    public CodeGenerationTest() {
        try {
            this.generator = CodeGenerator.generateCode((CodeGeneratorOption[])new CodeGeneratorOption[0]);
        }
        catch (CodeGenerationNotSupportedException e) {
            throw new AssertionError("Cannot compile code.", e);
        }
    }

    @Test
    public void shouldGenerateClass() throws Exception {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            handle = simple.handle();
        }
        Class aClass = handle.loadClass();
        Assert.assertNotNull((String)"null class loaded", (Object)aClass);
        Assert.assertNotNull((String)("null package of: " + aClass.getName()), (Object)aClass.getPackage());
        Assert.assertEquals((Object)PACKAGE, (Object)aClass.getPackage().getName());
        Assert.assertEquals((Object)"SimpleClass", (Object)aClass.getSimpleName());
    }

    @Test
    public void shouldGenerateTwoClassesInTheSamePackage() throws Exception {
        ClassHandle two;
        ClassHandle one;
        try (ClassGenerator simple = this.generateClass("One", new TypeReference[0]);){
            one = simple.handle();
        }
        simple = this.generateClass("Two", new TypeReference[0]);
        var4_2 = null;
        try {
            two = simple.handle();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (simple != null) {
                if (var4_2 != null) {
                    try {
                        simple.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    simple.close();
                }
            }
        }
        Class classOne = one.loadClass();
        Class classTwo = two.loadClass();
        Assert.assertNotNull((Object)classOne.getPackage());
        Assert.assertSame((Object)classOne.getPackage(), (Object)classTwo.getPackage());
        Assert.assertEquals((Object)"One", (Object)classOne.getSimpleName());
        Assert.assertEquals((Object)"Two", (Object)classTwo.getSimpleName());
    }

    @Test
    public void shouldGenerateField() throws Exception {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            simple.field(String.class, "theField");
            handle = simple.handle();
        }
        Class clazz = handle.loadClass();
        Field theField = clazz.getDeclaredField("theField");
        Assert.assertSame(String.class, theField.getType());
    }

    @Test
    public void shouldGenerateConstructorFromTemplate() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass(NamedBase.class, "SimpleClass", new Class[0]);){
            simple.field(String.class, "foo");
            simple.generate(MethodTemplate.constructor((Parameter[])new Parameter[]{Parameter.param(String.class, (String)"name"), Parameter.param(String.class, (String)"foo")}).invokeSuper(new ExpressionTemplate[]{ExpressionTemplate.load((String)"name")}).put(ExpressionTemplate.self(), String.class, "foo", ExpressionTemplate.load((String)"foo")).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), String.class, String.class).invoke("Pontus", "Tobias");
        Assert.assertEquals((Object)"SimpleClass", (Object)instance.getClass().getSimpleName());
        Assert.assertThat((Object)instance, (Matcher)CoreMatchers.instanceOf(NamedBase.class));
        Assert.assertEquals((Object)"Pontus", (Object)((NamedBase)instance).name);
        Assert.assertEquals((Object)"Tobias", (Object)CodeGenerationTest.getField(instance, "foo"));
    }

    @Test
    public void shouldGenerateMethodReturningFieldValue() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            FieldReference value = simple.field(String.class, "value");
            try (CodeBlock ctor = simple.generateConstructor(new Parameter[]{Parameter.param(String.class, (String)"value")});){
                ctor.put(ctor.self(), value, ctor.load("value"));
            }
            simple.generate(MethodTemplate.method(String.class, (String)"value", (Parameter[])new Parameter[0]).returns(ExpressionTemplate.get((ExpressionTemplate)ExpressionTemplate.self(), String.class, (String)"value")).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), String.class).invoke("Hello World");
        Assert.assertEquals((Object)"Hello World", (Object)CodeGenerationTest.instanceMethod(instance, "value", new Class[0]).invoke());
    }

    @Test
    public void shouldGenerateStaticField() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            TypeReference stringList = TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class});
            FieldReference foo = simple.staticField(stringList, "FOO", Expression.invoke((MethodReference)MethodReference.methodReference(Arrays.class, (TypeReference)stringList, (String)"asList", (Class[])new Class[]{String[].class}), (Expression[])new Expression[]{Expression.constant((Object)"FOO"), Expression.constant((Object)"BAR"), Expression.constant((Object)"BAZ")}));
            try (CodeBlock get = simple.generateMethod(stringList, "get", new Parameter[0]);){
                get.returns(Expression.get((FieldReference)foo));
            }
            handle = simple.handle();
        }
        Object foo = CodeGenerationTest.instanceMethod(handle.newInstance(), "get", new Class[0]).invoke();
        Assert.assertEquals(Arrays.asList("FOO", "BAR", "BAZ"), (Object)foo);
    }

    @Test
    public void shouldThrowParameterizedCheckedException() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock fail = simple.generate(MethodDeclaration.method(Void.TYPE, (String)"fail", (Parameter[])new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Thrower.class, (TypeReference[])new TypeReference[]{TypeReference.typeParameter((String)"E")}), (String)"thrower")}).parameterizedWith("E", TypeReference.extending(Exception.class)).throwsException(TypeReference.typeParameter((String)"E")));){
                fail.expression(Expression.invoke((Expression)fail.load("thrower"), (MethodReference)MethodReference.methodReference(Thrower.class, Void.TYPE, (String)"doThrow", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        try {
            CodeGenerationTest.instanceMethod(handle.newInstance(), "fail", Thrower.class).invoke(new Thrower<IOException>(){

                @Override
                public void doThrow() throws IOException {
                    throw new IOException("Hello from the inside");
                }
            });
            Assert.fail((String)"expected exception");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Hello from the inside", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAssignLocalVariable() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock create = simple.generateMethod(SomeBean.class, "createSomeBean", new Parameter[]{Parameter.param(String.class, (String)"foo"), Parameter.param(String.class, (String)"bar")});){
                create.assign(SomeBean.class, "bean", Expression.invoke((Expression)Expression.newInstance(SomeBean.class), (MethodReference)MethodReference.constructorReference(SomeBean.class, (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setFoo", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("foo")}));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setBar", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("bar")}));
                create.returns(create.load("bean"));
            }
            handle = simple.handle();
        }
        MethodHandle method = CodeGenerationTest.instanceMethod(handle.newInstance(), "createSomeBean", String.class, String.class);
        SomeBean bean = method.invoke("hello", "world");
        Assert.assertEquals((Object)"hello", (Object)bean.foo);
        Assert.assertEquals((Object)"world", (Object)bean.bar);
    }

    @Test
    public void shouldGenerateWhileLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterator.class, (Class[])new Class[]{Runnable.class}), (String)"targets")});
                 CodeBlock loop = callEach.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                loop.expression(Expression.invoke((Expression)Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Runnable.class, (String)"next", (Class[])new Class[0]), (Expression[])new Expression[0]), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterator.class);
        callEach.invoke(Arrays.asList(a, b, c).iterator());
        InOrder order = Mockito.inOrder((Object[])new Object[]{a, b, c});
        ((Runnable)order.verify((Object)a)).run();
        ((Runnable)order.verify((Object)b)).run();
        ((Runnable)order.verify((Object)c)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{a, b, c});
    }

    @Test
    public void shouldGenerateIfStatement() throws Throwable {
        ClassHandle handle;
        Object conditional;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
            Throwable throwable = null;
            try (CodeBlock doStuff = conditional.ifStatement(conditional.load("test"));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conditional != null) {
                    if (throwable != null) {
                        try {
                            conditional.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        conditional.close();
                    }
                }
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Runnable.class);
        conditional.invoke(true, runner1);
        conditional.invoke(false, runner2);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner2});
    }

    @Test
    public void shouldGenerateOr() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock doStuff = conditional.ifStatement(Expression.or((Expression)conditional.load("test1"), (Expression)conditional.load("test2")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner3 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner4 = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Runnable.class);
        conditional.invoke(true, true, runner1);
        conditional.invoke(true, false, runner2);
        conditional.invoke(false, true, runner3);
        conditional.invoke(false, false, runner4);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        ((Runnable)Mockito.verify((Object)runner2)).run();
        ((Runnable)Mockito.verify((Object)runner3)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner4});
    }

    @Test
    public void shouldGenerateTryWithResourceBlock() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock arm = simple.generate(MethodDeclaration.method(Void.TYPE, (String)"arm", (Parameter[])new Parameter[]{Parameter.param(ResourceFactory.class, (String)"factory")}).throwsException(Exception.class));
                 CodeBlock block = arm.tryBlock(AutoCloseable.class, "resource", Expression.invoke((Expression)arm.load("factory"), (MethodReference)MethodReference.methodReference(ResourceFactory.class, AutoCloseable.class, (String)"resource", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                block.expression(Expression.invoke((Expression)block.load("factory"), (MethodReference)MethodReference.methodReference(ResourceFactory.class, Void.TYPE, (String)"inside", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        ResourceFactory factory = new ResourceFactory();
        MethodHandle arm = CodeGenerationTest.instanceMethod(handle.newInstance(), "arm", ResourceFactory.class);
        arm.invoke(factory);
        Assert.assertEquals((long)1L, (long)factory.open);
        Assert.assertEquals((long)1L, (long)factory.inside);
        Assert.assertEquals((long)1L, (long)factory.close);
    }

    @Test
    public void shouldGenerateTryFinally() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock run = simple.generateMethod(Void.TYPE, "run", new Parameter[]{Parameter.param(Runnable.class, (String)"body"), Parameter.param(Runnable.class, (String)"finalize")});
                 TryBlock tryBlock = run.tryBlock(new Resource[0]);){
                tryBlock.expression(Expression.invoke((Expression)run.load("body"), (MethodReference)RUN, (Expression[])new Expression[0]));
                try (CodeBlock finallyBlock = tryBlock.finallyBlock();){
                    finallyBlock.expression(Expression.invoke((Expression)run.load("finalize"), (MethodReference)RUN, (Expression[])new Expression[0]));
                }
            }
            handle = simple.handle();
        }
        Runnable body = (Runnable)Mockito.mock(Runnable.class);
        Runnable finalize = (Runnable)Mockito.mock(Runnable.class);
        RuntimeException theFailure = new RuntimeException();
        ((Runnable)Mockito.doThrow((Throwable)theFailure).when((Object)body)).run();
        MethodHandle run = CodeGenerationTest.instanceMethod(handle.newInstance(), "run", Runnable.class, Runnable.class);
        try {
            run.invoke(body, finalize);
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)theFailure, (Object)e);
        }
        InOrder order = Mockito.inOrder((Object[])new Object[]{body, finalize});
        ((Runnable)order.verify((Object)body)).run();
        ((Runnable)order.verify((Object)finalize)).run();
    }

    @Test
    public void shouldThrowException() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock thrower = simple.generateMethod(Void.TYPE, "thrower", new Parameter[0]);){
                thrower.throwException(Expression.invoke((Expression)Expression.newInstance(RuntimeException.class), (MethodReference)MethodReference.constructorReference(RuntimeException.class, String.class, (Class[])new Class[0]), (Expression[])new Expression[]{Expression.constant((Object)"hello world")}));
            }
            handle = simple.handle();
        }
        try {
            CodeGenerationTest.instanceMethod(handle.newInstance(), "thrower", new Class[0]).invoke();
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)"hello world", (Object)exception.getMessage());
        }
    }

    static MethodHandle method(Class<?> target, String name, Class<?> ... parameters) throws Exception {
        return MethodHandles.lookup().unreflect(target.getMethod(name, parameters));
    }

    static MethodHandle instanceMethod(Object instance, String name, Class<?> ... parameters) throws Exception {
        return CodeGenerationTest.method(instance.getClass(), name, parameters).bindTo(instance);
    }

    static Object getField(Object instance, String field) throws Exception {
        return instance.getClass().getField(field).get(instance);
    }

    static MethodHandle constructor(Class<?> target, Class<?> ... parameters) throws Exception {
        return MethodHandles.lookup().unreflectConstructor(target.getConstructor(parameters));
    }

    ClassGenerator generateClass(String name, Class<?> firstInterface, Class<?> ... more) {
        return this.generator.generateClass(PACKAGE, name, firstInterface, (Class[])more);
    }

    ClassGenerator generateClass(Class<?> base, String name, Class<?> ... interfaces) {
        return this.generator.generateClass(base, PACKAGE, name, (Class[])interfaces);
    }

    ClassGenerator generateClass(String name, TypeReference ... interfaces) {
        return this.generator.generateClass(PACKAGE, name, interfaces);
    }

    ClassGenerator generateClass(TypeReference base, String name, TypeReference ... interfaces) {
        return this.generator.generateClass(base, PACKAGE, name, interfaces);
    }

    public static class ResourceFactory {
        int open;
        int close;
        int inside;

        public AutoCloseable resource() {
            ++this.open;
            return new AutoCloseable(){

                @Override
                public void close() throws Exception {
                    ++ResourceFactory.this.close;
                }
            };
        }

        public void inside() {
            ++this.inside;
        }
    }

    public static class SomeBean {
        private String foo;
        private String bar;

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }

    public static interface Thrower<E extends Exception> {
        public void doThrow() throws E;
    }

    public static class NamedBase {
        private final String name;

        public NamedBase(String name) {
            this.name = name;
        }
    }
}

