/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.codegen.source.ClasspathHelper;

public class ClasspathHelperTest {
    @Test
    public void shouldNotFailForNullClassLoader() {
        Assert.assertThat((Object)ClasspathHelper.fullClasspathFor(null), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldWorkForClassLoaderWithNoParent() throws Exception {
        URLClassLoader loader = new URLClassLoader(ClasspathHelperTest.urls("file:///file1", "file:///file2"), null);
        Set elements = ClasspathHelper.fullClasspathFor((ClassLoader)loader);
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasItems((Object[])new String[]{ClasspathHelperTest.pathTo("file1"), ClasspathHelperTest.pathTo("file2")}));
    }

    @Test
    public void shouldWorkForClassLoaderWithSingleParent() throws Exception {
        URLClassLoader parent = new URLClassLoader(ClasspathHelperTest.urls("file:///file1", "file:///file2"), null);
        URLClassLoader child = new URLClassLoader(ClasspathHelperTest.urls("file:///file3"), (ClassLoader)parent);
        Set elements = ClasspathHelper.fullClasspathFor((ClassLoader)child);
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasItems((Object[])new String[]{ClasspathHelperTest.pathTo("file1"), ClasspathHelperTest.pathTo("file2"), ClasspathHelperTest.pathTo("file3")}));
    }

    @Test
    public void shouldWorkForClassLoaderHierarchy() throws Exception {
        URLClassLoader loader1 = new URLClassLoader(ClasspathHelperTest.urls("file:///file1"), null);
        URLClassLoader loader2 = new URLClassLoader(ClasspathHelperTest.urls("file:///file2"), (ClassLoader)loader1);
        URLClassLoader loader3 = new URLClassLoader(ClasspathHelperTest.urls("file:///file3"), (ClassLoader)loader2);
        URLClassLoader loader4 = new URLClassLoader(ClasspathHelperTest.urls("file:///file4"), (ClassLoader)loader3);
        Set elements = ClasspathHelper.fullClasspathFor((ClassLoader)loader4);
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasItems((Object[])new String[]{ClasspathHelperTest.pathTo("file1"), ClasspathHelperTest.pathTo("file2"), ClasspathHelperTest.pathTo("file3"), ClasspathHelperTest.pathTo("file4")}));
    }

    @Test
    public void shouldReturnCorrectClasspathString() throws Exception {
        URLClassLoader parent = new URLClassLoader(ClasspathHelperTest.urls("file:///foo"), null);
        URLClassLoader child = new URLClassLoader(ClasspathHelperTest.urls("file:///bar"), (ClassLoader)parent);
        String classpath = ClasspathHelper.fullClasspathStringFor((ClassLoader)child);
        Assert.assertThat((Object)classpath, (Matcher)Matchers.containsString((String)(ClasspathHelperTest.pathTo("bar") + File.pathSeparator + ClasspathHelperTest.pathTo("foo"))));
    }

    private static URL[] urls(String ... strings) throws MalformedURLException {
        URL[] urls = new URL[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            urls[i] = new URL(strings[i]);
        }
        return urls;
    }

    private static String pathTo(String fileName) throws IOException {
        File currentDir = new File(".").getCanonicalFile();
        File root = currentDir.getParentFile().getCanonicalFile();
        while (root.getParentFile() != null) {
            root = root.getParentFile().getCanonicalFile();
        }
        return new File(root, fileName).getCanonicalPath();
    }
}

