/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.CodeGenerationTest;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public class ByteCodeUtilsTest {
    @Test
    public void shouldTranslateTypeNames() {
        this.assertTypeName(Integer.TYPE, "I");
        this.assertTypeName(Byte.TYPE, "B");
        this.assertTypeName(Short.TYPE, "S");
        this.assertTypeName(Character.TYPE, "C");
        this.assertTypeName(Float.TYPE, "F");
        this.assertTypeName(Double.TYPE, "D");
        this.assertTypeName(Boolean.TYPE, "Z");
        this.assertTypeName(Void.TYPE, "V");
        this.assertTypeName(int[].class, "[I");
        this.assertTypeName(byte[].class, "[B");
        this.assertTypeName(short[].class, "[S");
        this.assertTypeName(char[].class, "[C");
        this.assertTypeName(float[].class, "[F");
        this.assertTypeName(double[].class, "[D");
        this.assertTypeName(boolean[].class, "[Z");
        this.assertTypeName(String.class, "Ljava/lang/String;");
        this.assertTypeName(String[].class, "[Ljava/lang/String;");
    }

    @Test
    public void shouldDescribeMethodWithNoParameters() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method(Boolean.TYPE, (String)"foo", (Parameter[])new Parameter[0]).build(owner);
        String description = ByteCodeUtils.desc((MethodDeclaration)declaration);
        MatcherAssert.assertThat((Object)description, (Matcher)Matchers.equalTo((Object)"()Z"));
    }

    @Test
    public void shouldDescribeMethodWithParameters() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method(List.class, (String)"foo", (Parameter[])new Parameter[]{Parameter.param(String.class, (String)"string"), Parameter.param(char[].class, (String)"chararray")}).build(owner);
        String description = ByteCodeUtils.desc((MethodDeclaration)declaration);
        MatcherAssert.assertThat((Object)description, (Matcher)Matchers.equalTo((Object)"(Ljava/lang/String;[C)Ljava/util/List;"));
    }

    @Test
    public void signatureShouldBeNullWhenNotGeneric() {
        TypeReference reference = TypeReference.typeReference(String.class);
        String signature = ByteCodeUtils.signature((TypeReference)reference);
        Assert.assertNull((Object)signature);
    }

    @Test
    public void signatureShouldBeCorrectWhenGeneric() {
        TypeReference reference = TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class});
        String signature = ByteCodeUtils.signature((TypeReference)reference);
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"Ljava/util/List<Ljava/lang/String;>;"));
    }

    @Test
    public void methodSignatureShouldBeNullWhenNotGeneric() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method(String.class, (String)"foo", (Parameter[])new Parameter[]{Parameter.param(String.class, (String)"string"), Parameter.param(char[].class, (String)"chararray")}).build(owner);
        String signature = ByteCodeUtils.signature((MethodDeclaration)declaration);
        Assert.assertNull((Object)signature);
    }

    @Test
    public void methodSignatureShouldBeCorrectWhenGeneric() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method((TypeReference)TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class}), (String)"foo", (Parameter[])new Parameter[]{Parameter.param(String.class, (String)"string")}).build(owner);
        String signature = ByteCodeUtils.signature((MethodDeclaration)declaration);
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"(Ljava/lang/String;)Ljava/util/List<Ljava/lang/String;>;"));
    }

    @Test
    public void shouldHandleGenericReturnType() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method((TypeReference)TypeReference.typeParameter((String)"T"), (String)"fail", (Parameter[])new Parameter[0]).parameterizedWith("T", TypeReference.extending(Object.class)).build(owner);
        String desc = ByteCodeUtils.desc((MethodDeclaration)declaration);
        String signature = ByteCodeUtils.signature((MethodDeclaration)declaration);
        MatcherAssert.assertThat((Object)desc, (Matcher)Matchers.equalTo((Object)"()Ljava/lang/Object;"));
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"<T:Ljava/lang/Object;>()TT;"));
    }

    @Test
    public void shouldHandleGenericThrows() {
        TypeReference owner = TypeReference.typeReference(ByteCodeUtilsTest.class);
        MethodDeclaration declaration = MethodDeclaration.method(Void.TYPE, (String)"fail", (Parameter[])new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(CodeGenerationTest.Thrower.class, (TypeReference[])new TypeReference[]{TypeReference.typeParameter((String)"E")}), (String)"thrower")}).parameterizedWith("E", TypeReference.extending(Exception.class)).throwsException(TypeReference.typeParameter((String)"E")).build(owner);
        String signature = ByteCodeUtils.signature((MethodDeclaration)declaration);
        String[] exceptions = ByteCodeUtils.exceptions((MethodDeclaration)declaration);
        MatcherAssert.assertThat((Object)signature, (Matcher)Matchers.equalTo((Object)"<E:Ljava/lang/Exception;>(Lorg/neo4j/codegen/CodeGenerationTest$Thrower<TE;>;)V^TE;"));
        MatcherAssert.assertThat((Object)exceptions, (Matcher)Matchers.equalTo((Object)new String[]{"java/lang/Exception"}));
    }

    private void assertTypeName(Class<?> type, String expected) {
        TypeReference reference = TypeReference.typeReference(type);
        String byteCodeName = ByteCodeUtils.typeName((TypeReference)reference);
        MatcherAssert.assertThat((Object)byteCodeName, (Matcher)Matchers.equalTo((Object)expected));
    }
}

