/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.codegen.Binding;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.MethodTemplate;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.ByteCode;
import org.neo4j.codegen.source.SourceCode;

@RunWith(value=Parameterized.class)
public class CodeGenerationTest {
    public static final MethodReference RUN = CodeGenerationTest.createMethod(Runnable.class, Void.TYPE, "run");
    @Parameterized.Parameter(value=0)
    public CodeGenerationStrategy<?> strategy;
    public static final String PACKAGE = "org.neo4j.codegen.test";
    private CodeGenerator generator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> generators() {
        return Arrays.asList({SourceCode.SOURCECODE}, {ByteCode.BYTECODE});
    }

    @Before
    public void createGenerator() {
        try {
            this.generator = CodeGenerator.generateCode(this.strategy, (CodeGeneratorOption[])new CodeGeneratorOption[0]);
        }
        catch (CodeGenerationNotSupportedException e) {
            throw new AssertionError("Cannot compile code.", e);
        }
    }

    @Test
    public void shouldGenerateClass() throws Exception {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            handle = simple.handle();
        }
        Class aClass = handle.loadClass();
        Assert.assertNotNull((String)"null class loaded", (Object)aClass);
        Assert.assertNotNull((String)("null package of: " + aClass.getName()), (Object)aClass.getPackage());
        Assert.assertEquals((Object)PACKAGE, (Object)aClass.getPackage().getName());
        Assert.assertEquals((Object)"SimpleClass", (Object)aClass.getSimpleName());
    }

    @Test
    public void shouldGenerateTwoClassesInTheSamePackage() throws Exception {
        ClassHandle two;
        ClassHandle one;
        try (ClassGenerator simple = this.generateClass("One", new TypeReference[0]);){
            one = simple.handle();
        }
        simple = this.generateClass("Two", new TypeReference[0]);
        var4_2 = null;
        try {
            two = simple.handle();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (simple != null) {
                if (var4_2 != null) {
                    try {
                        simple.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    simple.close();
                }
            }
        }
        Class classOne = one.loadClass();
        Class classTwo = two.loadClass();
        Assert.assertNotNull((Object)classOne.getPackage());
        Assert.assertSame((Object)classOne.getPackage(), (Object)classTwo.getPackage());
        Assert.assertEquals((Object)"One", (Object)classOne.getSimpleName());
        Assert.assertEquals((Object)"Two", (Object)classTwo.getSimpleName());
    }

    @Test
    public void shouldGenerateDefaultConstructor() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass(NamedBase.class, "SimpleClass", new Class[0]);){
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), new Class[0]).invoke();
        Object constructorCalled = CodeGenerationTest.instanceMethod(instance, "defaultConstructorCalled", new Class[0]).invoke();
        Assert.assertTrue((boolean)((Boolean)constructorCalled));
    }

    @Test
    public void shouldGenerateField() throws Exception {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            simple.field(String.class, "theField");
            handle = simple.handle();
        }
        Class clazz = handle.loadClass();
        Field theField = clazz.getDeclaredField("theField");
        Assert.assertSame(String.class, theField.getType());
    }

    @Test
    public void shouldGenerateParameterizedTypeField() throws Exception {
        ClassHandle handle;
        TypeReference stringList = TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class});
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            simple.field(stringList, "theField");
            handle = simple.handle();
        }
        Class clazz = handle.loadClass();
        Field theField = clazz.getDeclaredField("theField");
        Assert.assertSame(List.class, theField.getType());
    }

    @Test
    public void shouldGenerateMethodReturningFieldValue() throws Throwable {
        this.assertMethodReturningField(Byte.TYPE, (byte)42);
        this.assertMethodReturningField(Short.TYPE, (short)42);
        this.assertMethodReturningField(Character.TYPE, Character.valueOf('*'));
        this.assertMethodReturningField(Integer.TYPE, 42);
        this.assertMethodReturningField(Long.TYPE, 42L);
        this.assertMethodReturningField(Float.TYPE, Float.valueOf(42.0f));
        this.assertMethodReturningField(Double.TYPE, 42.0);
        this.assertMethodReturningField(String.class, "42");
        this.assertMethodReturningField(int[].class, new int[]{42});
        this.assertMethodReturningField(Map.Entry[].class, Collections.singletonMap(42, "42").entrySet().toArray(new Map.Entry[0]));
    }

    @Test
    public void shouldGenerateMethodReturningArrayValue() throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            simple.generate(MethodTemplate.method(int[].class, (String)"value", (Parameter[])new Parameter[0]).returns((ExpressionTemplate)Expression.newArray((TypeReference)TypeReference.typeReference(Integer.TYPE), (Expression[])new Expression[]{Expression.constant((Object)1), Expression.constant((Object)2), Expression.constant((Object)3)})).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), new Class[0]).invoke();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])CodeGenerationTest.instanceMethod(instance, "value", new Class[0]).invoke());
    }

    @Test
    public void shouldGenerateMethodReturningParameterizedTypeValue() throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            TypeReference stringList = TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class});
            simple.generate(MethodTemplate.method((TypeReference)stringList, (String)"value", (Parameter[])new Parameter[0]).returns((ExpressionTemplate)Expression.invoke((MethodReference)MethodReference.methodReference(Arrays.class, (TypeReference)stringList, (String)"asList", (Class[])new Class[]{Object[].class}), (Expression[])new Expression[]{Expression.newArray((TypeReference)TypeReference.typeReference(String.class), (Expression[])new Expression[]{Expression.constant((Object)"a"), Expression.constant((Object)"b")})})).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), new Class[0]).invoke();
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)CodeGenerationTest.instanceMethod(instance, "value", new Class[0]).invoke());
    }

    @Test
    public void shouldGenerateStaticPrimitiveField() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            FieldReference foo = simple.staticField(Integer.TYPE, "FOO", Expression.constant((Object)42));
            try (CodeBlock get = simple.generateMethod(Integer.TYPE, "get", new Parameter[0]);){
                get.returns(Expression.getStatic((FieldReference)foo));
            }
            handle = simple.handle();
        }
        Object foo = CodeGenerationTest.instanceMethod(handle.newInstance(), "get", new Class[0]).invoke();
        Assert.assertEquals((Object)42, (Object)foo);
    }

    @Test
    public void shouldGenerateStaticReferenceTypeField() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            FieldReference foo = simple.staticField(String.class, "FOO", Expression.constant((Object)"42"));
            try (CodeBlock get = simple.generateMethod(String.class, "get", new Parameter[0]);){
                get.returns(Expression.getStatic((FieldReference)foo));
            }
            handle = simple.handle();
        }
        Object foo = CodeGenerationTest.instanceMethod(handle.newInstance(), "get", new Class[0]).invoke();
        Assert.assertEquals((Object)"42", (Object)foo);
    }

    @Test
    public void shouldGenerateStaticParameterizedTypeField() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            TypeReference stringList = TypeReference.parameterizedType(List.class, (Class[])new Class[]{String.class});
            FieldReference foo = simple.staticField(stringList, "FOO", Expression.invoke((MethodReference)MethodReference.methodReference(Arrays.class, (TypeReference)stringList, (String)"asList", (Class[])new Class[]{Object[].class}), (Expression[])new Expression[]{Expression.newArray((TypeReference)TypeReference.typeReference(String.class), (Expression[])new Expression[]{Expression.constant((Object)"FOO"), Expression.constant((Object)"BAR"), Expression.constant((Object)"BAZ")})}));
            try (CodeBlock get = simple.generateMethod(stringList, "get", new Parameter[0]);){
                get.returns(Expression.getStatic((FieldReference)foo));
            }
            handle = simple.handle();
        }
        Object foo = CodeGenerationTest.instanceMethod(handle.newInstance(), "get", new Class[0]).invoke();
        Assert.assertEquals(Arrays.asList("FOO", "BAR", "BAZ"), (Object)foo);
    }

    @Test
    public void shouldThrowParameterizedCheckedException() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock fail = simple.generate(MethodDeclaration.method(Void.TYPE, (String)"fail", (Parameter[])new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Thrower.class, (TypeReference[])new TypeReference[]{TypeReference.typeParameter((String)"E")}), (String)"thrower")}).parameterizedWith("E", TypeReference.extending(Exception.class)).throwsException(TypeReference.typeParameter((String)"E")));){
                fail.expression(Expression.invoke((Expression)fail.load("thrower"), (MethodReference)MethodReference.methodReference(Thrower.class, Void.TYPE, (String)"doThrow", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        try {
            CodeGenerationTest.instanceMethod(handle.newInstance(), "fail", Thrower.class).invoke(() -> {
                throw new IOException("Hello from the inside");
            });
            Assert.fail((String)"expected exception");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Hello from the inside", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAssignLocalVariable() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock create = simple.generateMethod(SomeBean.class, "createBean", new Parameter[]{Parameter.param(String.class, (String)"foo"), Parameter.param(String.class, (String)"bar")});){
                create.assign(SomeBean.class, "bean", Expression.invoke((Expression)Expression.newInstance(SomeBean.class), (MethodReference)MethodReference.constructorReference(SomeBean.class, (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setFoo", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("foo")}));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setBar", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("bar")}));
                create.returns(create.load("bean"));
            }
            handle = simple.handle();
        }
        MethodHandle method = CodeGenerationTest.instanceMethod(handle.newInstance(), "createBean", String.class, String.class);
        SomeBean bean = method.invoke("hello", "world");
        Assert.assertEquals((Object)"hello", (Object)bean.foo);
        Assert.assertEquals((Object)"world", (Object)bean.bar);
    }

    @Test
    public void shouldDeclareAndAssignLocalVariable() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock create = simple.generateMethod(SomeBean.class, "createBean", new Parameter[]{Parameter.param(String.class, (String)"foo"), Parameter.param(String.class, (String)"bar")});){
                LocalVariable localVariable = create.declare(TypeReference.typeReference(SomeBean.class), "bean");
                create.assign(localVariable, Expression.invoke((Expression)Expression.newInstance(SomeBean.class), (MethodReference)MethodReference.constructorReference(SomeBean.class, (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setFoo", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("foo")}));
                create.expression(Expression.invoke((Expression)create.load("bean"), (MethodReference)MethodReference.methodReference(SomeBean.class, Void.TYPE, (String)"setBar", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{create.load("bar")}));
                create.returns(create.load("bean"));
            }
            handle = simple.handle();
        }
        MethodHandle method = CodeGenerationTest.instanceMethod(handle.newInstance(), "createBean", String.class, String.class);
        SomeBean bean = method.invoke("hello", "world");
        Assert.assertEquals((Object)"hello", (Object)bean.foo);
        Assert.assertEquals((Object)"world", (Object)bean.bar);
    }

    @Test
    public void shouldGenerateWhileLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterator.class, (Class[])new Class[]{Runnable.class}), (String)"targets")});
                 CodeBlock loop = callEach.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                loop.expression(Expression.invoke((Expression)Expression.cast(Runnable.class, (Expression)Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Object.class, (String)"next", (Class[])new Class[0]), (Expression[])new Expression[0])), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterator.class);
        callEach.invoke(Arrays.asList(a, b, c).iterator());
        InOrder order = Mockito.inOrder((Object[])new Object[]{a, b, c});
        ((Runnable)order.verify((Object)a)).run();
        ((Runnable)order.verify((Object)b)).run();
        ((Runnable)order.verify((Object)c)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{a, b, c});
    }

    @Test
    public void shouldGenerateWhileLoopWithMultipleTestExpressions() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "check", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"a"), Parameter.param(Boolean.TYPE, (String)"b"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock loop = callEach.whileLoop(Expression.and((Expression)callEach.load("a"), (Expression)callEach.load("b")));){
                loop.expression(Expression.invoke((Expression)loop.load("runner"), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
                loop.returns();
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        Runnable d = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "check", Boolean.TYPE, Boolean.TYPE, Runnable.class);
        callEach.invoke(true, true, a);
        callEach.invoke(true, false, b);
        callEach.invoke(false, true, c);
        callEach.invoke(false, false, d);
        ((Runnable)Mockito.verify((Object)a)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{a});
        Mockito.verifyZeroInteractions((Object[])new Object[]{b});
        Mockito.verifyZeroInteractions((Object[])new Object[]{c});
        Mockito.verifyZeroInteractions((Object[])new Object[]{d});
    }

    @Test
    public void shouldGenerateNestedWhileLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterator.class, (Class[])new Class[]{Runnable.class}), (String)"targets")});
                 CodeBlock loop = callEach.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));
                 CodeBlock inner = loop.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                inner.expression(Expression.invoke((Expression)Expression.cast(Runnable.class, (Expression)Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Object.class, (String)"next", (Class[])new Class[0]), (Expression[])new Expression[0])), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterator.class);
        callEach.invoke(Arrays.asList(a, b, c).iterator());
        InOrder order = Mockito.inOrder((Object[])new Object[]{a, b, c});
        ((Runnable)order.verify((Object)a)).run();
        ((Runnable)order.verify((Object)b)).run();
        ((Runnable)order.verify((Object)c)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{a, b, c});
    }

    @Test
    public void shouldGenerateForEachLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterable.class, (Class[])new Class[]{Runnable.class}), (String)"targets")});
                 CodeBlock loop = callEach.forEach(Parameter.param(Runnable.class, (String)"runner"), callEach.load("targets"));){
                loop.expression(Expression.invoke((Expression)loop.load("runner"), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterable.class);
        callEach.invoke(Arrays.asList(a, b, c));
        InOrder order = Mockito.inOrder((Object[])new Object[]{a, b, c});
        ((Runnable)order.verify((Object)a)).run();
        ((Runnable)order.verify((Object)b)).run();
        ((Runnable)order.verify((Object)c)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{a, b, c});
    }

    @Test
    public void shouldGenerateIfStatement() throws Throwable {
        ClassHandle handle;
        Object conditional;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
            Throwable throwable = null;
            try (CodeBlock doStuff = conditional.ifStatement(conditional.load("test"));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conditional != null) {
                    if (throwable != null) {
                        try {
                            conditional.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conditional.close();
                    }
                }
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Runnable.class);
        conditional.invoke(true, runner1);
        conditional.invoke(false, runner2);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner2});
    }

    @Test
    public void shouldGenerateIfEqualsStatement() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Object.class, (String)"lhs"), Parameter.param(Object.class, (String)"rhs"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock doStuff = conditional.ifStatement(Expression.equal((Expression)conditional.load("lhs"), (Expression)conditional.load("rhs")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        String a = "a";
        String b = "b";
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Object.class, Object.class, Runnable.class);
        conditional.invoke(a, b, runner1);
        conditional.invoke(a, a, runner2);
        ((Runnable)Mockito.verify((Object)runner2)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner1});
    }

    @Test
    public void shouldGenerateIfNotEqualsStatement() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Object.class, (String)"lhs"), Parameter.param(Object.class, (String)"rhs"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock doStuff = conditional.ifStatement(Expression.not((Expression)Expression.equal((Expression)conditional.load("lhs"), (Expression)conditional.load("rhs"))));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        String a = "a";
        String b = "b";
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Object.class, Object.class, Runnable.class);
        conditional.invoke(a, a, runner1);
        conditional.invoke(a, b, runner2);
        ((Runnable)Mockito.verify((Object)runner2)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner1});
    }

    @Test
    public void shouldGenerateIfNotExpressionStatement() throws Throwable {
        ClassHandle handle;
        Object conditional;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
            Throwable throwable = null;
            try (CodeBlock doStuff = conditional.ifStatement(Expression.not((Expression)conditional.load("test")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conditional != null) {
                    if (throwable != null) {
                        try {
                            conditional.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conditional.close();
                    }
                }
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Runnable.class);
        conditional.invoke(true, runner1);
        conditional.invoke(false, runner2);
        ((Runnable)Mockito.verify((Object)runner2)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner1});
    }

    @Test
    public void shouldGenerateIfNullStatement() throws Throwable {
        ClassHandle handle;
        Object conditional;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Object.class, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
            Throwable throwable = null;
            try (CodeBlock doStuff = conditional.ifStatement(Expression.isNull((Expression)conditional.load("test")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conditional != null) {
                    if (throwable != null) {
                        try {
                            conditional.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conditional.close();
                    }
                }
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Object.class, Runnable.class);
        conditional.invoke(null, runner1);
        conditional.invoke(new Object(), runner2);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner2});
    }

    @Test
    public void shouldGenerateIfNonNullStatement() throws Throwable {
        ClassHandle handle;
        Object conditional;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Object.class, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
            Throwable throwable = null;
            try (CodeBlock doStuff = conditional.ifStatement(Expression.notNull((Expression)conditional.load("test")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conditional != null) {
                    if (throwable != null) {
                        try {
                            conditional.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conditional.close();
                    }
                }
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Object.class, Runnable.class);
        conditional.invoke(new Object(), runner1);
        conditional.invoke(null, runner2);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner2});
    }

    @Test
    public void shouldGenerateTryWithNestedWhileIfLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterator.class, (Class[])new Class[]{Runnable.class}), (String)"targets"), Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});){
                callEach.tryCatch(tryBlock -> {
                    try (CodeBlock loop = tryBlock.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                        try (CodeBlock doStuff = loop.ifStatement(Expression.not((Expression)callEach.load("test")));){
                            doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
                        }
                        loop.expression(Expression.invoke((Expression)Expression.cast(Runnable.class, (Expression)Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Object.class, (String)"next", (Class[])new Class[0]), (Expression[])new Expression[0])), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
                    }
                }, catchBlock -> catchBlock.expression(Expression.invoke((Expression)catchBlock.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0])), Parameter.param(RuntimeException.class, (String)"e"));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterator.class, Boolean.TYPE, Runnable.class);
        callEach.invoke(Arrays.asList(a, b, c).iterator(), false, runner1);
        callEach.invoke(Arrays.asList(a, b, c).iterator(), true, runner2);
        ((Runnable)Mockito.verify((Object)runner1, (VerificationMode)Mockito.times((int)3))).run();
        ((Runnable)Mockito.verify((Object)runner2, (VerificationMode)Mockito.times((int)0))).run();
    }

    @Test
    public void shouldGenerateWhileWithNestedIfLoop() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock callEach = simple.generateMethod(Void.TYPE, "callEach", new Parameter[]{Parameter.param((TypeReference)TypeReference.parameterizedType(Iterator.class, (Class[])new Class[]{Runnable.class}), (String)"targets"), Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock loop = callEach.whileLoop(Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Boolean.TYPE, (String)"hasNext", (Class[])new Class[0]), (Expression[])new Expression[0]));){
                try (CodeBlock doStuff = loop.ifStatement(Expression.not((Expression)callEach.load("test")));){
                    doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
                }
                loop.expression(Expression.invoke((Expression)Expression.cast(Runnable.class, (Expression)Expression.invoke((Expression)callEach.load("targets"), (MethodReference)MethodReference.methodReference(Iterator.class, Object.class, (String)"next", (Class[])new Class[0]), (Expression[])new Expression[0])), (MethodReference)MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]), (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable a = (Runnable)Mockito.mock(Runnable.class);
        Runnable b = (Runnable)Mockito.mock(Runnable.class);
        Runnable c = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle callEach = CodeGenerationTest.instanceMethod(handle.newInstance(), "callEach", Iterator.class, Boolean.TYPE, Runnable.class);
        callEach.invoke(Arrays.asList(a, b, c).iterator(), false, runner1);
        callEach.invoke(Arrays.asList(a, b, c).iterator(), true, runner2);
        ((Runnable)Mockito.verify((Object)runner1, (VerificationMode)Mockito.times((int)3))).run();
        ((Runnable)Mockito.verify((Object)runner2, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void shouldGenerateOr() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock doStuff = conditional.ifStatement(Expression.or((Expression)conditional.load("test1"), (Expression)conditional.load("test2")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner3 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner4 = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Runnable.class);
        conditional.invoke(true, true, runner1);
        conditional.invoke(true, false, runner2);
        conditional.invoke(false, true, runner3);
        conditional.invoke(false, false, runner4);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        ((Runnable)Mockito.verify((Object)runner2)).run();
        ((Runnable)Mockito.verify((Object)runner3)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner4});
    }

    @Test
    public void shouldGenerateMethodUsingOr() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2")});){
                conditional.returns(Expression.or((Expression)conditional.load("test1"), (Expression)conditional.load("test2")));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateAnd() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Void.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Runnable.class, (String)"runner")});
                 CodeBlock doStuff = conditional.ifStatement(Expression.and((Expression)conditional.load("test1"), (Expression)conditional.load("test2")));){
                doStuff.expression(Expression.invoke((Expression)doStuff.load("runner"), (MethodReference)RUN, (Expression[])new Expression[0]));
            }
            handle = simple.handle();
        }
        Runnable runner1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner3 = (Runnable)Mockito.mock(Runnable.class);
        Runnable runner4 = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Runnable.class);
        conditional.invoke(true, true, runner1);
        conditional.invoke(true, false, runner2);
        conditional.invoke(false, true, runner3);
        conditional.invoke(false, false, runner4);
        ((Runnable)Mockito.verify((Object)runner1)).run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner2});
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner3});
        Mockito.verifyZeroInteractions((Object[])new Object[]{runner4});
    }

    @Test
    public void shouldGenerateMethodUsingAnd() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2")});){
                conditional.returns(Expression.and((Expression)conditional.load("test1"), (Expression)conditional.load("test2")));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateMethodUsingMultipleAnds() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Boolean.TYPE, (String)"test3")});){
                conditional.returns(Expression.and((Expression)conditional.load("test1"), (Expression)Expression.and((Expression)conditional.load("test2"), (Expression)conditional.load("test3"))));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, true, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, false, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(true, true, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(true, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, true, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateMethodUsingMultipleAnds2() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Boolean.TYPE, (String)"test3")});){
                conditional.returns(Expression.and((Expression)Expression.and((Expression)conditional.load("test1"), (Expression)conditional.load("test2")), (Expression)conditional.load("test3")));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, true, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, false, true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(true, true, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(true, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, true, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateMethodUsingMultipleOrs() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Boolean.TYPE, (String)"test3")});){
                conditional.returns(Expression.or((Expression)conditional.load("test1"), (Expression)Expression.or((Expression)conditional.load("test2"), (Expression)conditional.load("test3"))));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, false, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, true, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, true, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateMethodUsingMultipleOrs2() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test1"), Parameter.param(Boolean.TYPE, (String)"test2"), Parameter.param(Boolean.TYPE, (String)"test3")});){
                conditional.returns(Expression.or((Expression)Expression.or((Expression)conditional.load("test1"), (Expression)conditional.load("test2")), (Expression)conditional.load("test3")));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, true, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, false, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, true, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(true, false, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, true, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)conditional.invoke(false, false, false), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldHandleNot() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock conditional = simple.generateMethod(Boolean.TYPE, "conditional", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test")});){
                conditional.returns(Expression.not((Expression)conditional.load("test")));
            }
            handle = simple.handle();
        }
        MethodHandle conditional = CodeGenerationTest.instanceMethod(handle.newInstance(), "conditional", Boolean.TYPE);
        Assert.assertThat((Object)conditional.invoke(true), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)conditional.invoke(false), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldHandleTernaryOperator() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock ternaryBlock = simple.generateMethod(String.class, "ternary", new Parameter[]{Parameter.param(Boolean.TYPE, (String)"test"), Parameter.param(TernaryChecker.class, (String)"check")});){
                ternaryBlock.returns(Expression.ternary((Expression)ternaryBlock.load("test"), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onTrue", (Class[])new Class[0]), (Expression[])new Expression[0]), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onFalse", (Class[])new Class[0]), (Expression[])new Expression[0])));
            }
            handle = simple.handle();
        }
        MethodHandle ternary = CodeGenerationTest.instanceMethod(handle.newInstance(), "ternary", Boolean.TYPE, TernaryChecker.class);
        TernaryChecker checker1 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(true, checker1), (Matcher)CoreMatchers.equalTo((Object)"on true"));
        Assert.assertTrue((boolean)checker1.ranOnTrue);
        Assert.assertFalse((boolean)checker1.ranOnFalse);
        TernaryChecker checker2 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(false, checker2), (Matcher)CoreMatchers.equalTo((Object)"on false"));
        Assert.assertFalse((boolean)checker2.ranOnTrue);
        Assert.assertTrue((boolean)checker2.ranOnFalse);
    }

    @Test
    public void shouldHandleTernaryOnNullOperator() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock ternaryBlock = simple.generateMethod(String.class, "ternary", new Parameter[]{Parameter.param(Object.class, (String)"test"), Parameter.param(TernaryChecker.class, (String)"check")});){
                ternaryBlock.returns(Expression.ternary((Expression)Expression.isNull((Expression)ternaryBlock.load("test")), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onTrue", (Class[])new Class[0]), (Expression[])new Expression[0]), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onFalse", (Class[])new Class[0]), (Expression[])new Expression[0])));
            }
            handle = simple.handle();
        }
        MethodHandle ternary = CodeGenerationTest.instanceMethod(handle.newInstance(), "ternary", Object.class, TernaryChecker.class);
        TernaryChecker checker1 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(null, checker1), (Matcher)CoreMatchers.equalTo((Object)"on true"));
        Assert.assertTrue((boolean)checker1.ranOnTrue);
        Assert.assertFalse((boolean)checker1.ranOnFalse);
        TernaryChecker checker2 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(new Object(), checker2), (Matcher)CoreMatchers.equalTo((Object)"on false"));
        Assert.assertFalse((boolean)checker2.ranOnTrue);
        Assert.assertTrue((boolean)checker2.ranOnFalse);
    }

    @Test
    public void shouldHandleTernaryOnNonNullOperator() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock ternaryBlock = simple.generateMethod(String.class, "ternary", new Parameter[]{Parameter.param(Object.class, (String)"test"), Parameter.param(TernaryChecker.class, (String)"check")});){
                ternaryBlock.returns(Expression.ternary((Expression)Expression.notNull((Expression)ternaryBlock.load("test")), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onTrue", (Class[])new Class[0]), (Expression[])new Expression[0]), (Expression)Expression.invoke((Expression)ternaryBlock.load("check"), (MethodReference)MethodReference.methodReference(TernaryChecker.class, String.class, (String)"onFalse", (Class[])new Class[0]), (Expression[])new Expression[0])));
            }
            handle = simple.handle();
        }
        MethodHandle ternary = CodeGenerationTest.instanceMethod(handle.newInstance(), "ternary", Object.class, TernaryChecker.class);
        TernaryChecker checker1 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(new Object(), checker1), (Matcher)CoreMatchers.equalTo((Object)"on true"));
        Assert.assertTrue((boolean)checker1.ranOnTrue);
        Assert.assertFalse((boolean)checker1.ranOnFalse);
        TernaryChecker checker2 = new TernaryChecker();
        Assert.assertThat((Object)ternary.invoke(null, checker2), (Matcher)CoreMatchers.equalTo((Object)"on false"));
        Assert.assertFalse((boolean)checker2.ranOnTrue);
        Assert.assertTrue((boolean)checker2.ranOnFalse);
    }

    @Test
    public void shouldHandleEquality() throws Throwable {
        Assert.assertTrue((boolean)this.compareForType(Boolean.TYPE, true, true, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Boolean.TYPE, false, false, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Boolean.TYPE, true, false, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Boolean.TYPE, false, true, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Byte.TYPE, (byte)42, (byte)42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Byte.TYPE, (byte)43, (byte)42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Byte.TYPE, (byte)42, (byte)43, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Short.TYPE, (short)42, (short)42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Short.TYPE, (short)43, (short)42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Short.TYPE, (short)42, (short)43, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Character.TYPE, Character.valueOf('*'), Character.valueOf('*'), Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Character.TYPE, Character.valueOf('+'), Character.valueOf('*'), Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Character.TYPE, Character.valueOf('*'), Character.valueOf('+'), Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Integer.TYPE, 42, 42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Integer.TYPE, 43, 42, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Integer.TYPE, 42, 43, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Long.TYPE, 42L, 42L, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Long.TYPE, 43L, 42L, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Long.TYPE, 42L, 43L, Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Float.TYPE, Float.valueOf(42.0f), Float.valueOf(42.0f), Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Float.TYPE, Float.valueOf(43.0f), Float.valueOf(42.0f), Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Float.TYPE, Float.valueOf(42.0f), Float.valueOf(43.0f), Expression::equal));
        Assert.assertTrue((boolean)this.compareForType(Double.TYPE, 42.0, 42.0, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Double.TYPE, 43.0, 42.0, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Double.TYPE, 42.0, 43.0, Expression::equal));
        Object obj1 = new Object();
        Object obj2 = new Object();
        Assert.assertTrue((boolean)this.compareForType(Object.class, obj1, obj1, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Object.class, obj1, obj2, Expression::equal));
        Assert.assertFalse((boolean)this.compareForType(Object.class, obj2, obj1, Expression::equal));
    }

    @Test
    public void shouldHandleGreaterThan() throws Throwable {
        Assert.assertTrue((boolean)this.compareForType(Float.TYPE, Float.valueOf(43.0f), Float.valueOf(42.0f), Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Long.TYPE, 43L, 42L, Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Byte.TYPE, (byte)43, (byte)42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Byte.TYPE, (byte)42, (byte)42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Byte.TYPE, (byte)42, (byte)43, Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Short.TYPE, (short)43, (short)42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Short.TYPE, (short)42, (short)42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Short.TYPE, (short)42, (short)43, Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Character.TYPE, Character.valueOf('+'), Character.valueOf('*'), Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Character.TYPE, Character.valueOf('*'), Character.valueOf('*'), Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Character.TYPE, Character.valueOf('*'), Character.valueOf('+'), Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Integer.TYPE, 43, 42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Integer.TYPE, 42, 42, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Integer.TYPE, 42, 43, Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Long.TYPE, 43L, 42L, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Long.TYPE, 42L, 42L, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Long.TYPE, 42L, 43L, Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Float.TYPE, Float.valueOf(43.0f), Float.valueOf(42.0f), Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Float.TYPE, Float.valueOf(42.0f), Float.valueOf(42.0f), Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Float.TYPE, Float.valueOf(42.0f), Float.valueOf(43.0f), Expression::gt));
        Assert.assertTrue((boolean)this.compareForType(Double.TYPE, 43.0, 42.0, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Double.TYPE, 42.0, 42.0, Expression::gt));
        Assert.assertFalse((boolean)this.compareForType(Double.TYPE, 42.0, 43.0, Expression::gt));
    }

    @Test
    public void shouldHandleAddition() throws Throwable {
        Assert.assertThat((Object)this.addForType(Integer.TYPE, 17, 18), (Matcher)CoreMatchers.equalTo((Object)35));
        Assert.assertThat((Object)this.addForType(Long.TYPE, 17L, 18L), (Matcher)CoreMatchers.equalTo((Object)35L));
        Assert.assertThat((Object)this.addForType(Double.TYPE, 17.0, 18.0), (Matcher)CoreMatchers.equalTo((Object)35.0));
    }

    @Test
    public void shouldHandleSubtraction() throws Throwable {
        Assert.assertThat((Object)this.subtractForType(Integer.TYPE, 19, 18), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)this.subtractForType(Long.TYPE, 19L, 18L), (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)this.subtractForType(Double.TYPE, 19.0, 18.0), (Matcher)CoreMatchers.equalTo((Object)1.0));
    }

    @Test
    public void shouldHandleMultiplication() throws Throwable {
        Assert.assertThat((Object)this.multiplyForType(Integer.TYPE, 17, 18), (Matcher)CoreMatchers.equalTo((Object)306));
        Assert.assertThat((Object)this.multiplyForType(Long.TYPE, 17L, 18L), (Matcher)CoreMatchers.equalTo((Object)306L));
        Assert.assertThat((Object)this.multiplyForType(Double.TYPE, 17.0, 18.0), (Matcher)CoreMatchers.equalTo((Object)306.0));
    }

    private <T> T addForType(Class<T> clazz, T lhs, T rhs) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock block = simple.generateMethod(clazz, "add", new Parameter[]{Parameter.param(clazz, (String)"a"), Parameter.param(clazz, (String)"b")});){
                block.returns(Expression.add((Expression)block.load("a"), (Expression)block.load("b")));
            }
            handle = simple.handle();
        }
        MethodHandle add = CodeGenerationTest.instanceMethod(handle.newInstance(), "add", clazz, clazz);
        return (T)add.invoke(lhs, rhs);
    }

    private <T> T subtractForType(Class<T> clazz, T lhs, T rhs) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock block = simple.generateMethod(clazz, "sub", new Parameter[]{Parameter.param(clazz, (String)"a"), Parameter.param(clazz, (String)"b")});){
                block.returns(Expression.subtract((Expression)block.load("a"), (Expression)block.load("b")));
            }
            handle = simple.handle();
        }
        MethodHandle sub = CodeGenerationTest.instanceMethod(handle.newInstance(), "sub", clazz, clazz);
        return (T)sub.invoke(lhs, rhs);
    }

    private <T> T multiplyForType(Class<T> clazz, T lhs, T rhs) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock block = simple.generateMethod(clazz, "multiply", new Parameter[]{Parameter.param(clazz, (String)"a"), Parameter.param(clazz, (String)"b")});){
                block.returns(Expression.multiply((Expression)block.load("a"), (Expression)block.load("b")));
            }
            handle = simple.handle();
        }
        MethodHandle sub = CodeGenerationTest.instanceMethod(handle.newInstance(), "multiply", clazz, clazz);
        return (T)sub.invoke(lhs, rhs);
    }

    private <T> boolean compareForType(Class<T> clazz, T lhs, T rhs, BiFunction<Expression, Expression, Expression> compare) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock block = simple.generateMethod(Boolean.TYPE, "compare", new Parameter[]{Parameter.param(clazz, (String)"a"), Parameter.param(clazz, (String)"b")});){
                block.returns(compare.apply(block.load("a"), block.load("b")));
            }
            handle = simple.handle();
        }
        MethodHandle compareFcn = CodeGenerationTest.instanceMethod(handle.newInstance(), "compare", clazz, clazz);
        return compareFcn.invoke(lhs, rhs);
    }

    @Test
    public void shouldGenerateTryCatch() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock run = simple.generateMethod(Void.TYPE, "run", new Parameter[]{Parameter.param(Runnable.class, (String)"body"), Parameter.param(Runnable.class, (String)"catcher")});){
                run.tryCatch(body -> body.expression(Expression.invoke((Expression)run.load("body"), (MethodReference)RUN, (Expression[])new Expression[0])), handler -> handler.expression(Expression.invoke((Expression)run.load("catcher"), (MethodReference)RUN, (Expression[])new Expression[0])), Parameter.param(RuntimeException.class, (String)"E"));
            }
            handle = simple.handle();
        }
        Runnable successBody = (Runnable)Mockito.mock(Runnable.class);
        Runnable failBody = (Runnable)Mockito.mock(Runnable.class);
        Runnable successCatch = (Runnable)Mockito.mock(Runnable.class);
        Runnable failCatch = (Runnable)Mockito.mock(Runnable.class);
        RuntimeException theFailure = new RuntimeException();
        ((Runnable)Mockito.doThrow((Throwable[])new Throwable[]{theFailure}).when((Object)failBody)).run();
        MethodHandle run = CodeGenerationTest.instanceMethod(handle.newInstance(), "run", Runnable.class, Runnable.class);
        run.invoke(successBody, successCatch);
        ((Runnable)Mockito.verify((Object)successBody)).run();
        ((Runnable)Mockito.verify((Object)successCatch, (VerificationMode)Mockito.never())).run();
        run.invoke(failBody, failCatch);
        InOrder orderFailure = Mockito.inOrder((Object[])new Object[]{failBody, failCatch});
        ((Runnable)orderFailure.verify((Object)failBody)).run();
        ((Runnable)orderFailure.verify((Object)failCatch)).run();
    }

    @Test
    public void shouldGenerateTryCatchWithNestedBlock() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock run = simple.generateMethod(Void.TYPE, "run", new Parameter[]{Parameter.param(Runnable.class, (String)"body"), Parameter.param(Runnable.class, (String)"catcher"), Parameter.param(Boolean.TYPE, (String)"test")});){
                run.tryCatch(tryBlock -> {
                    try (CodeBlock ifBlock = tryBlock.ifStatement(run.load("test"));){
                        ifBlock.expression(Expression.invoke((Expression)run.load("body"), (MethodReference)RUN, (Expression[])new Expression[0]));
                    }
                }, catchBlock -> catchBlock.expression(Expression.invoke((Expression)run.load("catcher"), (MethodReference)RUN, (Expression[])new Expression[0])), Parameter.param(RuntimeException.class, (String)"E"));
            }
            handle = simple.handle();
        }
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        MethodHandle run = CodeGenerationTest.instanceMethod(handle.newInstance(), "run", Runnable.class, Runnable.class, Boolean.TYPE);
        run.invoke(runnable, (Runnable)Mockito.mock(Runnable.class), false);
        ((Runnable)Mockito.verify((Object)runnable, (VerificationMode)Mockito.never())).run();
        run.invoke(runnable, (Runnable)Mockito.mock(Runnable.class), true);
        ((Runnable)Mockito.verify((Object)runnable)).run();
    }

    @Test
    public void shouldGenerateTryAndMultipleCatch() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock run = simple.generateMethod(Void.TYPE, "run", new Parameter[]{Parameter.param(Runnable.class, (String)"body"), Parameter.param(Runnable.class, (String)"catcher1"), Parameter.param(Runnable.class, (String)"catcher2")});){
                run.tryCatch(tryBlock -> tryBlock.tryCatch(innerTry -> innerTry.expression(Expression.invoke((Expression)run.load("body"), (MethodReference)RUN, (Expression[])new Expression[0])), catchBlock1 -> catchBlock1.expression(Expression.invoke((Expression)run.load("catcher1"), (MethodReference)RUN, (Expression[])new Expression[0])), Parameter.param(MyFirstException.class, (String)"E")), catchBlock2 -> catchBlock2.expression(Expression.invoke((Expression)run.load("catcher2"), (MethodReference)RUN, (Expression[])new Expression[0])), Parameter.param(MySecondException.class, (String)"E"));
            }
            handle = simple.handle();
        }
        Runnable body1 = (Runnable)Mockito.mock(Runnable.class);
        Runnable body2 = (Runnable)Mockito.mock(Runnable.class);
        Runnable catcher11 = (Runnable)Mockito.mock(Runnable.class);
        Runnable catcher12 = (Runnable)Mockito.mock(Runnable.class);
        Runnable catcher21 = (Runnable)Mockito.mock(Runnable.class);
        Runnable catcher22 = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow(MyFirstException.class).when((Object)body1)).run();
        ((Runnable)Mockito.doThrow(MySecondException.class).when((Object)body2)).run();
        MethodHandle run = CodeGenerationTest.instanceMethod(handle.newInstance(), "run", Runnable.class, Runnable.class, Runnable.class);
        run.invoke(body1, catcher11, catcher12);
        ((Runnable)Mockito.verify((Object)body1)).run();
        ((Runnable)Mockito.verify((Object)catcher11)).run();
        ((Runnable)Mockito.verify((Object)catcher12, (VerificationMode)Mockito.never())).run();
        run.invoke(body2, catcher21, catcher22);
        ((Runnable)Mockito.verify((Object)body2)).run();
        ((Runnable)Mockito.verify((Object)catcher22)).run();
        ((Runnable)Mockito.verify((Object)catcher21, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void shouldThrowException() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock thrower = simple.generateMethod(Void.TYPE, "thrower", new Parameter[0]);){
                thrower.throwException(Expression.invoke((Expression)Expression.newInstance(RuntimeException.class), (MethodReference)MethodReference.constructorReference(RuntimeException.class, String.class, (Class[])new Class[0]), (Expression[])new Expression[]{Expression.constant((Object)"hello world")}));
            }
            handle = simple.handle();
        }
        try {
            CodeGenerationTest.instanceMethod(handle.newInstance(), "thrower", new Class[0]).invoke();
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)"hello world", (Object)exception.getMessage());
        }
    }

    @Test
    public void shouldBeAbleToCast() throws Throwable {
        ClassHandle handle;
        try (ClassGenerator simple = this.generateClass(NamedBase.class, "SimpleClass", new Class[0]);){
            simple.field(String.class, "foo");
            simple.generate(MethodTemplate.constructor((Parameter[])new Parameter[]{Parameter.param(String.class, (String)"name"), Parameter.param(Object.class, (String)"foo")}).invokeSuper(new ExpressionTemplate[]{ExpressionTemplate.load((String)"name", (TypeReference)TypeReference.typeReference(String.class))}, new TypeReference[]{TypeReference.typeReference(String.class)}).put(ExpressionTemplate.self((TypeReference)simple.handle()), String.class, "foo", ExpressionTemplate.cast(String.class, (ExpressionTemplate)ExpressionTemplate.load((String)"foo", (TypeReference)TypeReference.typeReference(Object.class)))).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), String.class, Object.class).invoke("Pontus", "Tobias");
        Assert.assertEquals((Object)"SimpleClass", (Object)instance.getClass().getSimpleName());
        Assert.assertThat((Object)instance, (Matcher)CoreMatchers.instanceOf(NamedBase.class));
        Assert.assertEquals((Object)"Pontus", (Object)((NamedBase)instance).name);
        Assert.assertEquals((Object)"Tobias", (Object)CodeGenerationTest.getField(instance, "foo"));
    }

    @Test
    public void shouldBeAbleToBox() throws Throwable {
        Assert.assertThat((Object)this.boxTest(Boolean.TYPE, true), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.boxTest(Boolean.TYPE, false), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.boxTest(Byte.TYPE, (byte)12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.boxTest(Short.TYPE, (short)12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.boxTest(Integer.TYPE, 12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.boxTest(Long.TYPE, 12L), (Matcher)CoreMatchers.equalTo((Object)12L));
        Assert.assertThat((Object)this.boxTest(Float.TYPE, Float.valueOf(12.0f)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(12.0f)));
        Assert.assertThat((Object)this.boxTest(Double.TYPE, 12.0), (Matcher)CoreMatchers.equalTo((Object)12.0));
        Assert.assertThat((Object)this.boxTest(Character.TYPE, Character.valueOf('a')), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf('a')));
    }

    @Test
    public void shouldBeAbleToUnbox() throws Throwable {
        Assert.assertThat((Object)this.unboxTest(Boolean.class, Boolean.TYPE, true), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.unboxTest(Boolean.class, Boolean.TYPE, false), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)this.unboxTest(Byte.class, Byte.TYPE, (byte)12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.unboxTest(Short.class, Short.TYPE, (short)12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.unboxTest(Integer.class, Integer.TYPE, 12), (Matcher)CoreMatchers.equalTo((Object)12));
        Assert.assertThat((Object)this.unboxTest(Long.class, Long.TYPE, 12L), (Matcher)CoreMatchers.equalTo((Object)12L));
        Assert.assertThat((Object)this.unboxTest(Float.class, Float.TYPE, Float.valueOf(12.0f)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(12.0f)));
        Assert.assertThat((Object)this.unboxTest(Double.class, Double.TYPE, 12.0), (Matcher)CoreMatchers.equalTo((Object)12.0));
        Assert.assertThat((Object)this.unboxTest(Character.class, Character.TYPE, Character.valueOf('a')), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf('a')));
    }

    private <T> Object unboxTest(Class<T> boxedType, Class<?> unboxedType, T value) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock method = simple.generateMethod(unboxedType, "unbox", new Parameter[]{Parameter.param(boxedType, (String)"test")});){
                method.returns(Expression.unbox((Expression)method.load("test")));
            }
            handle = simple.handle();
        }
        return CodeGenerationTest.instanceMethod(handle.newInstance(), "unbox", boxedType).invoke(value);
    }

    private <T> Object boxTest(Class<T> unboxedType, T value) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            try (CodeBlock method = simple.generateMethod(Object.class, "box", new Parameter[]{Parameter.param(unboxedType, (String)"test")});){
                method.returns(Expression.box((Expression)method.load("test")));
            }
            handle = simple.handle();
        }
        return CodeGenerationTest.instanceMethod(handle.newInstance(), "box", unboxedType).invoke(value);
    }

    private MethodHandle conditional(Function<CodeBlock, Expression> test, Parameter ... params) {
        throw new UnsupportedOperationException("not implemented");
    }

    static MethodHandle method(Class<?> target, String name, Class<?> ... parameters) throws Exception {
        return MethodHandles.lookup().unreflect(target.getMethod(name, parameters));
    }

    public static MethodHandle instanceMethod(Object instance, String name, Class<?> ... parameters) throws Exception {
        return CodeGenerationTest.method(instance.getClass(), name, parameters).bindTo(instance);
    }

    static Object getField(Object instance, String field) throws Exception {
        return instance.getClass().getField(field).get(instance);
    }

    static MethodHandle constructor(Class<?> target, Class<?> ... parameters) throws Exception {
        return MethodHandles.lookup().unreflectConstructor(target.getConstructor(parameters));
    }

    ClassGenerator generateClass(String name, Class<?> firstInterface, Class<?> ... more) {
        return this.generator.generateClass(PACKAGE, name, firstInterface, (Class[])more);
    }

    ClassGenerator generateClass(Class<?> base, String name, Class<?> ... interfaces) {
        return this.generator.generateClass(base, PACKAGE, name, (Class[])interfaces);
    }

    ClassGenerator generateClass(String name, TypeReference ... interfaces) {
        return this.generator.generateClass(PACKAGE, name, interfaces);
    }

    ClassGenerator generateClass(TypeReference base, String name, TypeReference ... interfaces) {
        return this.generator.generateClass(base, PACKAGE, name, interfaces);
    }

    private <T> void assertMethodReturningField(Class<T> clazz, T argument) throws Throwable {
        ClassHandle handle;
        this.createGenerator();
        try (ClassGenerator simple = this.generateClass("SimpleClass", new TypeReference[0]);){
            FieldReference value = simple.field(clazz, "value");
            simple.generate(MethodTemplate.constructor((Parameter[])new Parameter[]{Parameter.param(clazz, (String)"value")}).invokeSuper().put(ExpressionTemplate.self((TypeReference)simple.handle()), value.type(), value.name(), ExpressionTemplate.load((String)"value", (TypeReference)value.type())).build(), new Binding[0]);
            simple.generate(MethodTemplate.method(clazz, (String)"value", (Parameter[])new Parameter[0]).returns(ExpressionTemplate.get((ExpressionTemplate)ExpressionTemplate.self((TypeReference)simple.handle()), clazz, (String)"value")).build(), new Binding[0]);
            handle = simple.handle();
        }
        Object instance = CodeGenerationTest.constructor(handle.loadClass(), clazz).invoke(argument);
        Assert.assertEquals(argument, (Object)CodeGenerationTest.instanceMethod(instance, "value", new Class[0]).invoke());
    }

    private static MethodReference createMethod(Class<?> owner, Class<?> returnType, String name) {
        return MethodReference.methodReference(Runnable.class, Void.TYPE, (String)"run", (Class[])new Class[0]);
    }

    public static class MySecondException
    extends RuntimeException {
    }

    public static class MyFirstException
    extends RuntimeException {
    }

    public static class SomeBean {
        private String foo;
        private String bar;

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }

    public static class NamedBase {
        final String name;
        private boolean defaultConstructorCalled;

        public NamedBase() {
            this.defaultConstructorCalled = true;
            this.name = null;
        }

        public NamedBase(String name) {
            this.name = name;
        }

        public boolean defaultConstructorCalled() {
            return this.defaultConstructorCalled;
        }
    }

    public static class TernaryChecker {
        private boolean ranOnTrue;
        private boolean ranOnFalse;

        public String onTrue() {
            this.ranOnTrue = true;
            return "on true";
        }

        public String onFalse() {
            this.ranOnFalse = true;
            return "on false";
        }
    }

    public static interface Thrower<E extends Exception> {
        public void doThrow() throws E;
    }
}

