/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.ByteCode;

public class ByteCodeVerifierTest {
    @Test
    public void shouldVerifyBytecode() throws Throwable {
        ClassHandle handle;
        CodeGenerator generator = CodeGenerator.generateCode((CodeGenerationStrategy)ByteCode.BYTECODE, (CodeGeneratorOption[])new CodeGeneratorOption[]{ByteCode.VERIFY_GENERATED_BYTECODE});
        try (ClassGenerator clazz = generator.generateClass("org.neo4j.codegen.test", "SimpleClass", new TypeReference[0]);
             CodeBlock code = clazz.generateMethod(Integer.class, "box", new Parameter[]{Parameter.param(Integer.TYPE, (String)"value")});){
            handle = clazz.handle();
            code.returns(code.load("value"));
        }
        try {
            handle.loadClass();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (CompilationFailureException expected) {
            Assert.assertThat((Object)expected.toString(), (Matcher)CoreMatchers.containsString((String)"box(I)"));
        }
    }
}

