/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.LruCache;

public class LruCacheTest {
    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenMaxSizeIsNotGreaterThanZero() {
        new LruCache("TestCache", 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenPuttingEntryWithNullKey() {
        new LruCache("TestCache", 70).put(null, new Object());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenPuttingEntryWithNullValue() {
        new LruCache("TestCache", 70).put(new Object(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenGettingWithANullKey() {
        new LruCache("TestCache", 70).get(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenRemovingWithANullKey() {
        new LruCache("TestCache", 70).remove(null);
    }

    @Test
    public void shouldWork() {
        LruCache cache = new LruCache("TestCache", 3);
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(key1, key2, key3)), (Object)cache.keySet());
        cache.put((Object)key4, (Object)s4);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(key2, key3, key4)), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(key2, key4, key5)), (Object)cache.keySet());
        int size = cache.size();
        Assert.assertEquals((long)3L, (long)size);
        Assert.assertEquals(null, (Object)cache.get((Object)key1));
        Assert.assertEquals((Object)s2, (Object)cache.get((Object)key2));
        Assert.assertEquals(null, (Object)cache.get((Object)key3));
        Assert.assertEquals((Object)s4, (Object)cache.get((Object)key4));
        Assert.assertEquals((Object)s5, (Object)cache.get((Object)key5));
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void shouldResizeTheCache() {
        final HashSet cleaned = new HashSet();
        LruCache<Integer, String> cache = new LruCache<Integer, String>("TestCache", 3){

            public void elementCleaned(String element) {
                cleaned.add(element);
            }
        };
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3), (Object)cache.keySet());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(5);
        Assert.assertEquals((long)5L, (long)cache.maxSize());
        Assert.assertEquals((long)3L, (long)cache.size());
        Assert.assertTrue((boolean)cleaned.isEmpty());
        cache.put((Object)key4, (Object)s4);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3, key4), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3, key4, key5), (Object)cache.keySet());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(4);
        Assert.assertEquals(LruCacheTest.set(key2, key3, key4, key5), (Object)cache.keySet());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        Assert.assertEquals(LruCacheTest.set(s1), cleaned);
        cleaned.clear();
        cache.resize(3);
        Assert.assertEquals(LruCacheTest.set(key2, key4, key5), (Object)cache.keySet());
        Assert.assertEquals((long)3L, (long)cache.maxSize());
        Assert.assertEquals((long)3L, (long)cache.size());
        Assert.assertEquals(LruCacheTest.set(s3), cleaned);
    }

    @Test
    public void shouldClear() {
        final HashSet cleaned = new HashSet();
        LruCache<Integer, String> cache = new LruCache<Integer, String>("TestCache", 3){

            public void elementCleaned(String element) {
                cleaned.add(element);
            }
        };
        String s1 = "1";
        Integer key1 = 1;
        String s2 = "2";
        Integer key2 = 2;
        String s3 = "3";
        Integer key3 = 3;
        String s4 = "4";
        Integer key4 = 4;
        String s5 = "5";
        Integer key5 = 5;
        cache.put((Object)key1, (Object)s1);
        cache.put((Object)key2, (Object)s2);
        cache.put((Object)key3, (Object)s3);
        cache.get((Object)key2);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3), (Object)cache.keySet());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.resize(5);
        Assert.assertEquals((long)5L, (long)cache.maxSize());
        Assert.assertEquals((long)3L, (long)cache.size());
        cache.put((Object)key4, (Object)s4);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3, key4), (Object)cache.keySet());
        cache.put((Object)key5, (Object)s5);
        Assert.assertEquals(LruCacheTest.set(key1, key2, key3, key4, key5), (Object)cache.keySet());
        Assert.assertEquals((long)cache.maxSize(), (long)cache.size());
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertEquals(LruCacheTest.set(s1, s2, s3, s4, s5), cleaned);
    }

    public static <E> Set<E> set(E ... elems) {
        return new HashSet<E>(Arrays.asList(elems));
    }
}

