/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.exceptions.UnsatisfiedDependencyException;

class DependenciesTest {
    DependenciesTest() {
    }

    @Test
    void givenSatisfiedTypeWhenResolveWithTypeThenInstanceReturned() {
        Dependencies dependencies = new Dependencies();
        String foo = "foo";
        dependencies.satisfyDependency((Object)foo);
        String instance = (String)dependencies.resolveDependency(String.class);
        Assertions.assertThat((String)instance).isEqualTo(foo);
    }

    @Test
    void givenSatisfiedTypeWhenResolveWithSuperTypeThenInstanceReturned() {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        AbstractList instance = (AbstractList)dependencies.resolveDependency(AbstractList.class);
        Assertions.assertThat((List)instance).isEqualTo(foo);
    }

    @Test
    void givenSatisfiedTypeWhenResolveWithInterfaceThenInstanceReturned() {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        List instance = (List)dependencies.resolveDependency(List.class);
        Assertions.assertThat((List)instance).isEqualTo(foo);
    }

    @Test
    void givenSatisfiedTypeWhenResolveWithSubInterfaceThenInstanceReturned() {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assertions.assertThat((Iterable)instance).isEqualTo(foo);
    }

    @Test
    void givenSatisfiedTypeInParentWhenResolveWithTypeInEmptyDependenciesThenInstanceReturned() {
        Dependencies parent = new Dependencies();
        Dependencies dependencies = new Dependencies((DependencyResolver)parent);
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assertions.assertThat((Iterable)instance).isEqualTo(foo);
    }

    @Test
    void givenSatisfiedTypeInParentAndDependenciesWhenResolveWithTypeInDependenciesThenInstanceReturned() {
        Dependencies parent = new Dependencies();
        Dependencies dependencies = new Dependencies((DependencyResolver)parent);
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        parent.satisfyDependency(new ArrayList());
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assertions.assertThat((Iterable)instance).isEqualTo(foo);
    }

    @Test
    void givenEmptyDependenciesWhenResolveWithTypeThenException() {
        Dependencies dependencies = new Dependencies();
        org.junit.jupiter.api.Assertions.assertThrows(UnsatisfiedDependencyException.class, () -> dependencies.resolveDependency(Collection.class));
    }

    @Test
    void failSelectFromMultipleAvailableOptions() {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        List<String> bar = Collections.singletonList("a");
        dependencies.satisfyDependency(foo);
        dependencies.satisfyDependency(bar);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> dependencies.resolveDependency(List.class));
    }
}

