/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.internal.Longs;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveArrays;

class PrimitiveArraysTest {
    private static final int[] NO_INTS = new int[0];
    private static final int[] ONE_INT = new int[]{1};
    private static final long[] NO_LONGS = new long[0];
    private static final long[] ONE_LONG = new long[]{1L};

    PrimitiveArraysTest() {
    }

    @Test
    void union_shouldHandleNullInput() {
        Assertions.assertThat((int[])PrimitiveArrays.union(null, null)).isNull();
        Assertions.assertThat((int[])PrimitiveArrays.union(null, (int[])NO_INTS)).isEqualTo((Object)NO_INTS);
        Assertions.assertThat((int[])PrimitiveArrays.union((int[])NO_INTS, null)).isEqualTo((Object)NO_INTS);
        Assertions.assertThat((int[])PrimitiveArrays.union(null, (int[])ONE_INT)).isEqualTo((Object)ONE_INT);
        Assertions.assertThat((int[])PrimitiveArrays.union((int[])ONE_INT, null)).isEqualTo((Object)ONE_INT);
    }

    @Test
    void intersect_shouldHandleNullInput() {
        Assertions.assertThat((long[])PrimitiveArrays.intersect(null, null)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.intersect(null, (long[])NO_LONGS)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])NO_LONGS, null)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.intersect(null, (long[])ONE_LONG)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])ONE_LONG, null)).isEqualTo((Object)NO_LONGS);
    }

    @Test
    void intersect_shouldHandleNonIntersectingArrays() {
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L})).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{14L, 15L, 16L}, (long[])new long[]{1L, 2L, 3L})).isEqualTo((Object)NO_LONGS);
    }

    @Test
    void intersect_shouldHandleIntersectingArrays() {
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 4L, 5L})).containsExactly(new long[]{3L});
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{3L, 4L, 5L}, (long[])new long[]{1L, 2L, 3L, 4L})).containsExactly(new long[]{3L, 4L});
    }

    @Test
    void intersect_shouldHandleComplexIntersectingArraysWithGaps() {
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L})).containsExactly(new long[]{4L, 9L, 12L});
        Assertions.assertThat((long[])PrimitiveArrays.intersect((long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}, (long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L})).containsExactly(new long[]{4L, 9L, 12L});
    }

    @Test
    void symDiff_shouldHandleNullInput() {
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference(null, null)).isEqualTo(null);
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference(null, (long[])NO_LONGS)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])NO_LONGS, null)).isEqualTo((Object)NO_LONGS);
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference(null, (long[])ONE_LONG)).isEqualTo((Object)ONE_LONG);
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])ONE_LONG, null)).isEqualTo((Object)ONE_LONG);
    }

    @Test
    void symDiff_shouldHandleNonIntersectingArrays() {
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L})).containsExactly(new long[]{1L, 2L, 3L, 4L, 5L, 6L});
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{14L, 15L, 16L}, (long[])new long[]{1L, 2L, 3L})).containsExactly(new long[]{1L, 2L, 3L, 14L, 15L, 16L});
    }

    @Test
    void symDiff_shouldHandleIntersectingArrays() {
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 4L, 5L})).containsExactly(new long[]{1L, 2L, 4L, 5L});
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{3L, 4L, 5L}, (long[])new long[]{1L, 2L, 3L, 4L})).containsExactly(new long[]{1L, 2L, 5L});
    }

    @Test
    void symDiff_shouldHandleComplexIntersectingArraysWithGaps() {
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L})).containsExactly(new long[]{2L, 3L, 6L, 7L, 8L, 11L, 15L, 16L, 19L});
        Assertions.assertThat((long[])PrimitiveArrays.symmetricDifference((long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L}, (long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L})).containsExactly(new long[]{2L, 3L, 6L, 7L, 8L, 11L, 15L, 16L, 19L});
    }

    @Test
    void shouldCountUnique() {
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{4L, 5L, 6L})).hasCounts(3, 3);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L, 6L})).hasCounts(2, 1);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{1L, 2L, 3L}, (long[])new long[]{3L})).hasCounts(2, 0);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{3L}, (long[])new long[]{1L, 2L, 3L})).hasCounts(0, 2);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{3L}, (long[])new long[]{3L})).hasCounts(0, 0);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{3L, 6L, 8L}, (long[])new long[0])).hasCounts(3, 0);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[0], (long[])new long[]{3L, 6L, 8L})).hasCounts(0, 3);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[0], (long[])new long[0])).hasCounts(0, 0);
        IntPairAssert.assertThat(PrimitiveArrays.countUnique((long[])new long[]{4L, 6L, 9L, 11L, 12L, 15L}, (long[])new long[]{2L, 3L, 4L, 7L, 8L, 9L, 12L, 16L, 19L})).hasCounts(3, 6);
    }

    private static class IntPairAssert
    extends AbstractAssert<IntPairAssert, Long> {
        private final Longs longs = Longs.instance();

        static IntPairAssert assertThat(long value) {
            return new IntPairAssert(value);
        }

        IntPairAssert(Long value) {
            super((Object)value, IntPairAssert.class);
        }

        IntPairAssert hasCounts(int left, int right) {
            this.isNotNull();
            long expectedValue = (long)left << 32 | (long)right;
            this.longs.assertEqual((AssertionInfo)this.info, (Object)((Long)this.actual), (Object)expectedValue);
            return (IntPairAssert)this.myself;
        }
    }
}

