/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.PrimitiveArrays;

public class PrimitiveArraysUnionTest {
    private static final long SEED = ThreadLocalRandom.current().nextLong();
    private static final Random random = new Random(SEED);
    private static final int MINIMUM_RANDOM_SIZE = 10;

    public static Iterable<Object[]> parameters() {
        List<Object[]> inputs = Stream.generate(PrimitiveArraysUnionTest::randomInput).limit(300L).collect(Collectors.toList());
        List manuallyDefinedValues = Arrays.asList(PrimitiveArraysUnionTest.lhs(1, 2, 3).rhs(1, 2, 3).expectLhs(), PrimitiveArraysUnionTest.lhs(1, 2, 3).rhs(1).expectLhs(), PrimitiveArraysUnionTest.lhs(1, 2, 3).rhs(2).expectLhs(), PrimitiveArraysUnionTest.lhs(1, 2, 3).rhs(3).expectLhs(), PrimitiveArraysUnionTest.lhs(1).rhs(1, 2, 3).expectRhs(), PrimitiveArraysUnionTest.lhs(2).rhs(1, 2, 3).expectRhs(), PrimitiveArraysUnionTest.lhs(3).rhs(1, 2, 3).expectRhs(), PrimitiveArraysUnionTest.lhs(1, 2, 3).rhs(4, 5, 6).expect(1, 2, 3, 4, 5, 6), PrimitiveArraysUnionTest.lhs(1, 3, 5).rhs(2, 4, 6).expect(1, 2, 3, 4, 5, 6), PrimitiveArraysUnionTest.lhs(1, 2, 3, 5).rhs(2, 4, 6).expect(1, 2, 3, 4, 5, 6), PrimitiveArraysUnionTest.lhs(2, 3, 4, 7, 8, 9, 12, 16, 19).rhs(4, 6, 9, 11, 12, 15).expect(2, 3, 4, 6, 7, 8, 9, 11, 12, 15, 16, 19), PrimitiveArraysUnionTest.lhs(10, 13).rhs(13, 18).expect(10, 13, 18), PrimitiveArraysUnionTest.lhs(13, 18).rhs(10, 13).expect(10, 13, 18));
        inputs.addAll(manuallyDefinedValues);
        return inputs;
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testUnion(Input input) {
        int[] lhs = input.lhs;
        int[] rhs = input.rhs;
        int[] expected = input.expected;
        int[] actual = PrimitiveArrays.union((int[])lhs, (int[])rhs);
        if (lhs == expected || rhs == expected) {
            Assertions.assertSame((Object)expected, (Object)actual);
        } else {
            Assertions.assertArrayEquals((int[])expected, (int[])actual, (String)("Arrays should be equal. Test seed value: " + SEED));
        }
    }

    private static Input.Lhs lhs(int ... lhs) {
        return new Input.Lhs(lhs);
    }

    private static Object[] randomInput() {
        int randomArraySize = 10 + random.nextInt(100);
        int lhsSize = random.nextInt(randomArraySize);
        int rhsSize = randomArraySize - lhsSize;
        int[] resultValues = new int[randomArraySize];
        int[] lhs = new int[lhsSize];
        int[] rhs = new int[rhsSize];
        int lhsSideItems = 0;
        int rhsSideItems = 0;
        int index = 0;
        int value = random.nextInt(10);
        do {
            if (random.nextBoolean()) {
                if (rhsSideItems < rhsSize) {
                    rhs[rhsSideItems++] = value;
                } else {
                    lhs[lhsSideItems++] = value;
                }
            } else if (lhsSideItems < lhsSize) {
                lhs[lhsSideItems++] = value;
            } else {
                rhs[rhsSideItems++] = value;
            }
            resultValues[index++] = value;
            value += 1 + random.nextInt(10);
        } while (index < randomArraySize);
        return new Object[]{new Input(lhs, rhs, resultValues)};
    }

    static class Input {
        final int[] lhs;
        final int[] rhs;
        final int[] expected;

        Input(int[] lhs, int[] rhs, int[] expected) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.expected = expected;
        }

        public String toString() {
            return String.format("{lhs=%s, rhs=%s, expected=%s}", Arrays.toString(this.lhs), Arrays.toString(this.rhs), Arrays.toString(this.expected));
        }

        static class Rhs {
            final int[] lhs;
            final int[] rhs;

            Rhs(int[] lhs, int[] rhs) {
                this.lhs = lhs;
                this.rhs = rhs;
            }

            Object[] expect(int ... expected) {
                return new Object[]{new Input(this.lhs, this.rhs, expected)};
            }

            Object[] expectLhs() {
                return new Object[]{new Input(this.lhs, this.rhs, this.lhs)};
            }

            Object[] expectRhs() {
                return new Object[]{new Input(this.lhs, this.rhs, this.rhs)};
            }
        }

        static class Lhs {
            final int[] lhs;

            Lhs(int[] lhs) {
                this.lhs = lhs;
            }

            Rhs rhs(int ... rhs) {
                return new Rhs(this.lhs, rhs);
            }
        }
    }
}

