/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;

class PrimitiveLongCollectionsTest {
    PrimitiveLongCollectionsTest() {
    }

    @Test
    void singleIterator() {
        LongIterator iterator = PrimitiveLongCollections.single((long)42L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((long)42L, (long)iterator.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> ((LongIterator)iterator).next());
    }

    @Test
    void arrayOfItemsAsIterator() {
        long[] items = new long[]{2L, 5L, 234L};
        LongIterator iterator = PrimitiveLongCollections.iterator((long[])items);
        PrimitiveLongCollectionsTest.assertItems(iterator, items);
    }

    @Test
    void reverseArrayOfItemsAsIterator() {
        long[] items = new long[]{2L, 5L, 234L};
        LongIterator iterator = PrimitiveLongCollections.reverseIterator((long[])items);
        PrimitiveLongCollectionsTest.assertItems(iterator, 234L, 5L, 2L);
    }

    @Test
    void filter() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        LongIterator filtered = PrimitiveLongCollections.filter((LongIterator)items, item -> item != 2L);
        PrimitiveLongCollectionsTest.assertItems(filtered, 1L, 3L);
    }

    @Test
    void indexOf() {
        Supplier<LongIterator> items = () -> PrimitiveLongCollections.iterator((long[])new long[]{10L, 20L, 30L});
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)55L));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)20L));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)PrimitiveLongCollections.indexOf((LongIterator)items.get(), (long)30L));
    }

    @Test
    void count() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        int count = PrimitiveLongCollections.count((LongIterator)items);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)count);
    }

    @Test
    void asArray() {
        LongIterator items = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L, 3L});
        long[] array = PrimitiveLongCollections.asArray((LongIterator)items);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])array);
    }

    @Test
    void shouldDeduplicate() {
        long[] array = new long[]{1L, 1L, 2L, 5L, 6L, 6L};
        long[] deduped = PrimitiveLongCollections.deduplicate((long[])array);
        org.junit.jupiter.api.Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 5L, 6L}, (long[])deduped);
    }

    @Test
    void shouldDeduplicateWithRandomArrays() {
        int arrayLength = 5000;
        int iterations = 10;
        for (int i = 0; i < iterations; ++i) {
            long[] array = ThreadLocalRandom.current().longs(arrayLength, 0L, arrayLength).sorted().toArray();
            long[] dedupedActual = PrimitiveLongCollections.deduplicate((long[])array);
            TreeSet<Long> set = new TreeSet<Long>();
            for (long value : array) {
                set.add(value);
            }
            long[] dedupedExpected = new long[set.size()];
            Iterator itr = set.iterator();
            for (int j = 0; j < dedupedExpected.length; ++j) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)itr.hasNext());
                dedupedExpected[j] = (Long)itr.next();
            }
            org.junit.jupiter.api.Assertions.assertArrayEquals((long[])dedupedExpected, (long[])dedupedActual);
        }
    }

    @Test
    void shouldNotContinueToCallNextOnHasNextFalse() {
        final AtomicLong count = new AtomicLong(2L);
        PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator iterator = new PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator(){

            protected boolean fetchNext() {
                return count.decrementAndGet() >= 0L && this.next(count.get());
            }
        };
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)iterator.next());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)iterator.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)count.get());
    }

    @Test
    void convertJavaCollectionToSetOfPrimitives() {
        List<Long> longs = Arrays.asList(1L, 4L, 7L);
        MutableLongSet longSet = PrimitiveLongCollections.asSet(longs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)longSet.contains(1L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)longSet.contains(4L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)longSet.contains(7L));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)longSet.size());
    }

    @Test
    void convertPrimitiveSetToJavaSet() {
        LongHashSet longSet = LongHashSet.newSetWith((long[])new long[]{1L, 3L, 5L});
        Set longs = PrimitiveLongCollections.toSet((LongSet)longSet);
        Assertions.assertThat((Iterable)longs).contains((Object[])new Long[]{1L, 3L, 5L});
    }

    @Test
    void mergeLongIterableToSet() {
        Assertions.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)new LongHashSet(), (LongIterable)new LongHashSet())).isEqualTo((Object)new LongHashSet());
        Assertions.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)new LongHashSet())).isEqualTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}));
        Assertions.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}))).isEqualTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}));
        Assertions.assertThat((Object)PrimitiveLongCollections.mergeToSet((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L}), (LongIterable)LongHashSet.newSetWith((long[])new long[]{4L, 5L, 6L}))).isEqualTo((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}));
    }

    private static void assertNoMoreItems(LongIterator iterator) {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext(), (String)(iterator + " should have no more items"));
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> ((LongIterator)iterator).next());
    }

    private static void assertNextEquals(long expected, LongIterator iterator) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)iterator.hasNext(), (String)(iterator + " should have had more items"));
        org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)iterator.next());
    }

    private static void assertItems(LongIterator iterator, long ... expectedItems) {
        for (long expectedItem : expectedItems) {
            PrimitiveLongCollectionsTest.assertNextEquals(expectedItem, iterator);
        }
        PrimitiveLongCollectionsTest.assertNoMoreItems(iterator);
    }
}

