/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;

class PrimitiveLongResourceCollectionsTest {
    PrimitiveLongResourceCollectionsTest() {
    }

    @Test
    void simpleIterator() {
        CountingResource resource = new CountingResource();
        PrimitiveLongResourceIterator iterator = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{1L, 2L, 3L, 4L});
        PrimitiveLongResourceCollectionsTest.assertContent(iterator, 1L, 2L, 3L, 4L);
        iterator.close();
        Assertions.assertEquals((int)1, (int)resource.closeCount(), (String)"exactly one call to close");
    }

    @Test
    void concatIterators() {
        CountingResource resource = new CountingResource();
        PrimitiveLongResourceIterator first = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{1L, 2L});
        PrimitiveLongResourceIterator second = PrimitiveLongResourceCollections.iterator((Resource)resource, (long[])new long[]{3L, 4L});
        PrimitiveLongResourceIterator concat = PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])new PrimitiveLongResourceIterator[]{first, second});
        PrimitiveLongResourceCollectionsTest.assertContent(concat, 1L, 2L, 3L, 4L);
        concat.close();
        Assertions.assertEquals((int)2, (int)resource.closeCount(), (String)"all concatenated iterators are closed");
    }

    private static void assertContent(PrimitiveLongResourceIterator iterator, long ... expected) {
        int i = 0;
        while (iterator.hasNext()) {
            Assertions.assertEquals((long)expected[i++], (long)iterator.next(), (String)"has expected value");
        }
        Assertions.assertEquals((int)expected.length, (int)i, (String)"has all expected values");
    }

    private static class CountingResource
    implements Resource {
        private final AtomicInteger closed = new AtomicInteger();

        private CountingResource() {
        }

        public void close() {
            this.closed.incrementAndGet();
        }

        int closeCount() {
            return this.closed.get();
        }
    }
}

