/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RangeLongIterator;

class RangeLongIteratorTest {
    RangeLongIteratorTest() {
    }

    @Test
    void shouldIterateOverSubsetOfData() {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        RangeLongIterator iterator = new RangeLongIterator(array, 2, 2);
        Assertions.assertThat((long)iterator.next()).isEqualTo(3L);
        Assertions.assertThat((long)iterator.next()).isEqualTo(4L);
        Assertions.assertThat((boolean)iterator.hasNext()).isEqualTo(false);
    }

    @Test
    void shouldNotBeAbleToCreateInvalidRanges() {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new RangeLongIterator(array, -1, 0));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new RangeLongIterator(array, 0, -1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new RangeLongIterator(array, 10, 2));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new RangeLongIterator(array, 0, 12));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new RangeLongIterator(array, 4, 4));
    }
}

