/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.CombiningResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;

class CombiningResourceIteratorTest {
    CombiningResourceIteratorTest() {
    }

    @Test
    void shouldNotCloseDuringIteration() {
        ResourceIterator it1 = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])new Long[]{1L, 2L, 3L})));
        ResourceIterator it2 = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])new Long[]{5L, 6L, 7L})));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(Iterators.iterator((Object[])new ResourceIterator[]{it1, it2}));
        Assertions.assertThat((List)Iterators.asList((Iterator)combingIterator)).isEqualTo(Arrays.asList(1L, 2L, 3L, 5L, 6L, 7L));
        ((ResourceIterator)Mockito.verify((Object)it1, (VerificationMode)Mockito.never())).close();
        ((ResourceIterator)Mockito.verify((Object)it2, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void closesAllIteratorsOnShutdown() {
        ResourceIterator it1 = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])new Long[]{1L, 2L, 3L})));
        ResourceIterator it2 = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])new Long[]{5L, 6L, 7L})));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(Iterators.iterator((Object[])new ResourceIterator[]{it1, it2}));
        int iterations = 4;
        while (iterations-- > 0) {
            combingIterator.next();
        }
        combingIterator.close();
        ((ResourceIterator)Mockito.verify((Object)it1)).close();
        ((ResourceIterator)Mockito.verify((Object)it2)).close();
    }

    @Test
    void shouldHandleSingleItemIterators() {
        ResourceIterator it1 = Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)1L));
        ResourceIterator it2 = Iterators.asResourceIterator((Iterator)Iterators.iterator((Object[])new Long[]{5L, 6L, 7L}));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(Iterators.iterator((Object[])new ResourceIterator[]{it1, it2}));
        Assertions.assertThat((List)Iterators.asList((Iterator)combingIterator)).isEqualTo(Arrays.asList(1L, 5L, 6L, 7L));
    }
}

