/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.FirstItemIterable;

class FirstItemIterableTest {
    FirstItemIterableTest() {
    }

    @Test
    void testEmptyIterator() {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Collections.emptyList());
        Iterator empty = firstItemIterable.iterator();
        Assertions.assertFalse((boolean)empty.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, empty::next);
        Assertions.assertNull((Object)firstItemIterable.getFirst());
    }

    @Test
    void testSingleIterator() {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Collections.singleton(Boolean.TRUE));
        Iterator empty = firstItemIterable.iterator();
        Assertions.assertTrue((boolean)empty.hasNext());
        Assertions.assertEquals((Object)Boolean.TRUE, empty.next());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assertions.assertFalse((boolean)empty.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, empty::next);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
    }

    @Test
    void testMultiIterator() {
        FirstItemIterable firstItemIterable = new FirstItemIterable(Arrays.asList(Boolean.TRUE, Boolean.FALSE));
        Iterator empty = firstItemIterable.iterator();
        Assertions.assertTrue((boolean)empty.hasNext());
        Assertions.assertEquals((Object)Boolean.TRUE, empty.next());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assertions.assertTrue((boolean)empty.hasNext());
        Assertions.assertEquals((Object)Boolean.FALSE, empty.next());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
        Assertions.assertFalse((boolean)empty.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, empty::next);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)firstItemIterable.getFirst());
    }
}

