/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterables;

class IterablesTest {
    IterablesTest() {
    }

    @Test
    void safeForAllShouldConsumeAllSubjectsRegardlessOfSuccess() {
        ArrayList seenSubjects = new ArrayList();
        ArrayList failedSubjects = new ArrayList();
        ThrowingConsumer consumer = s -> {
            seenSubjects.add(s);
            if (seenSubjects.size() % 2 == 1) {
                failedSubjects.add(s);
                throw new RuntimeException((String)s);
            }
        };
        List<String> subjects = Arrays.asList("1", "2", "3", "4", "5");
        try {
            Iterables.safeForAll((ThrowingConsumer)consumer, subjects);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals(subjects, seenSubjects);
            Iterator failed = failedSubjects.iterator();
            Assertions.assertTrue((boolean)failed.hasNext());
            Assertions.assertEquals((Object)e.getMessage(), failed.next());
            for (Throwable suppressed : e.getSuppressed()) {
                Assertions.assertTrue((boolean)failed.hasNext());
                Assertions.assertEquals((Object)suppressed.getMessage(), failed.next());
            }
            Assertions.assertFalse((boolean)failed.hasNext());
        }
    }
}

