/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.helpers.collection.LongRange;

class LongRangeTest {
    LongRangeTest() {
    }

    @Test
    void shouldBeWithinRange() {
        int from = 4;
        int to = 8;
        LongRange range = LongRange.range((long)from, (long)to);
        Assertions.assertFalse((boolean)range.isWithinRange((long)(from - 1)));
        Assertions.assertFalse((boolean)range.isWithinRange((long)(to + 1)));
        for (int i = from; i < to + 1; ++i) {
            Assertions.assertTrue((boolean)range.isWithinRange((long)i));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"validRanges"})
    void shouldBeWithinRange(RangeProvider rangeProvider) {
        Assertions.assertDoesNotThrow(rangeProvider::get);
    }

    @ParameterizedTest
    @MethodSource(value={"invalidRanges"})
    void checkInvalidRanges(RangeProvider rangeProvider) {
        Assertions.assertThrows(IllegalArgumentException.class, rangeProvider::get);
    }

    private static Stream<RangeProvider> invalidRanges() {
        return Stream.of(new RangeProvider(1L, 0L), new RangeProvider(Long.MAX_VALUE, Long.MIN_VALUE), new RangeProvider(-1L, 0L));
    }

    private static Stream<RangeProvider> validRanges() {
        return Stream.of(new RangeProvider(0L, 0L), new RangeProvider(Long.MAX_VALUE, Long.MAX_VALUE), new RangeProvider(0L, Long.MAX_VALUE));
    }

    static class RangeProvider {
        private final long from;
        private final long to;

        RangeProvider(long from, long to) {
            this.from = from;
            this.to = to;
        }

        LongRange get() {
            return LongRange.range((long)this.from, (long)this.to);
        }

        public String toString() {
            return "RangeProvider{from=" + this.from + ", to=" + this.to + "}";
        }
    }
}

